/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.jonathangiles.tools.sitebuilder.util.SitePaths;

public class FileUtils {
    private FileUtils() {
    }

    public static Path getPath(String path, ClassLoader loader) {
        return new File(loader.getResource(path).getFile()).toPath();
    }

    public static void writeToFile(Path file, String content) {
        try {
            Files.write(file, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(Path basePath, Path file) {
        try {
            Path newPath = SitePaths.createRelativePath(basePath, file);
            System.out.println("Copying static file: " + String.valueOf(newPath));
            newPath.toFile().mkdirs();
            Files.copy(file, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readFile(Path file) {
        StringBuilder sb = new StringBuilder();
        try {
            Files.lines(file, StandardCharsets.UTF_8).forEach(line -> sb.append((String)line).append("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

