/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder.models.input;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.jonathangiles.tools.sitebuilder.models.input.InputFile;
import net.jonathangiles.tools.sitebuilder.util.FileUtils;

public class XmlFile
implements InputFile {
    private final Map<String, List<String>> frontMatter;
    private final String body;

    private XmlFile(Map<String, List<String>> frontMatter, String body) {
        this.frontMatter = frontMatter;
        this.body = body;
    }

    static XmlFile fromFile(File xmlFile) {
        HashMap<String, List<String>> frontMatter = new HashMap<String, List<String>>();
        String xmlContent = FileUtils.readFile(xmlFile.toPath());
        XmlMapper mapper = new XmlMapper();
        String body = "";
        try {
            LinkedHashMap map = (LinkedHashMap)mapper.readValue(xmlContent, Object.class);
            for (Object key : map.keySet()) {
                if (key.equals("Content")) {
                    body = (String)map.get(key);
                    continue;
                }
                frontMatter.put((String)key, List.of((String)map.get(key)));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return new XmlFile(frontMatter, body);
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public List<String> getFrontMatterList(String key) {
        return this.frontMatter.getOrDefault(key, null);
    }

    @Override
    public Optional<String> getFrontMatterValue(String key) {
        key = ((String)key).substring(0, 1).toUpperCase() + ((String)key).substring(1);
        return InputFile.super.getFrontMatterValue((String)key);
    }

    @Override
    public boolean hasFrontMatter() {
        return !this.frontMatter.isEmpty();
    }
}

