/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder.models.input;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.jonathangiles.tools.sitebuilder.models.input.InputFile;
import org.commonmark.ext.front.matter.YamlFrontMatterExtension;
import org.commonmark.ext.front.matter.YamlFrontMatterVisitor;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class MarkdownFile
implements InputFile {
    private static final Parser PARSER = Parser.builder().extensions(List.of(YamlFrontMatterExtension.create())).build();
    private static final HtmlRenderer HTML_RENDERER = HtmlRenderer.builder().build();
    private final Map<String, List<String>> frontMatter;
    private final String content;

    private MarkdownFile(Map<String, List<String>> frontMatter, String content) {
        this.frontMatter = frontMatter;
        this.content = content;
        if (!frontMatter.containsKey("template")) {
            frontMatter.put("template", List.of("page"));
        }
    }

    static MarkdownFile fromFile(File markdownFile) {
        Node document = null;
        try {
            document = PARSER.parseReader((Reader)new FileReader(markdownFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        YamlFrontMatterVisitor frontMatter = new YamlFrontMatterVisitor();
        document.accept((Visitor)frontMatter);
        return new MarkdownFile(frontMatter.getData(), HTML_RENDERER.render(document));
    }

    @Override
    public String getBody() {
        return this.content;
    }

    @Override
    public List<String> getFrontMatterList(String key) {
        return this.frontMatter.getOrDefault(key, null);
    }

    @Override
    public boolean hasFrontMatter() {
        return !this.frontMatter.isEmpty();
    }
}

