/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder.models.input;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.jonathangiles.tools.sitebuilder.models.input.HtmlFile;
import net.jonathangiles.tools.sitebuilder.models.input.MarkdownFile;
import net.jonathangiles.tools.sitebuilder.models.input.XmlFile;

public interface InputFile {
    public String getBody();

    public List<String> getFrontMatterList(String var1);

    default public Optional<String> getFrontMatterValue(String key) {
        if (!this.hasFrontMatter(key)) {
            return Optional.empty();
        }
        return Optional.of(this.getFrontMatterList(key).get(0));
    }

    public boolean hasFrontMatter();

    default public boolean hasFrontMatter(String key) {
        return this.hasFrontMatter() && this.getFrontMatterList(key) != null;
    }

    public static InputFile fromPath(Path path) {
        return InputFile.fromFile(path.toFile());
    }

    public static InputFile fromFile(File file) {
        if (file.getName().endsWith(".md")) {
            return InputFile.fromMarkdownFile(file);
        }
        if (file.getName().endsWith(".html")) {
            return InputFile.fromHtmlFile(file);
        }
        if (file.getName().endsWith(".xml")) {
            return InputFile.fromXmlFile(file);
        }
        throw new RuntimeException("Unknown file type: " + file.getName());
    }

    public static MarkdownFile fromMarkdownFile(File markdownFile) {
        return MarkdownFile.fromFile(markdownFile);
    }

    public static HtmlFile fromHtmlFile(File htmlFile) {
        return HtmlFile.fromFile(htmlFile);
    }

    public static XmlFile fromXmlFile(File xmlFile) {
        return XmlFile.fromFile(xmlFile);
    }
}

