/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder.models.input;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jonathangiles.tools.sitebuilder.models.input.InputFile;
import net.jonathangiles.tools.sitebuilder.util.FileUtils;

public class HtmlFile
implements InputFile {
    private final Map<String, List<String>> frontMatter;
    private final String content;

    private HtmlFile(Map<String, List<String>> frontMatter, String content) {
        this.frontMatter = frontMatter;
        this.content = content;
    }

    static HtmlFile fromFile(File htmlFile) {
        String html = FileUtils.readFile(htmlFile.toPath());
        Map<String, List<String>> frontMatter = HtmlFile.readFrontMatter(html);
        html = html.replaceFirst("<!--.*?-->", "");
        return new HtmlFile(frontMatter, html);
    }

    @Override
    public String getBody() {
        return this.content;
    }

    @Override
    public List<String> getFrontMatterList(String key) {
        return this.frontMatter.get(key);
    }

    @Override
    public boolean hasFrontMatter() {
        return !this.frontMatter.isEmpty();
    }

    private static Map<String, List<String>> readFrontMatter(String html) {
        HashMap<String, List<String>> frontMatter = new HashMap<String, List<String>>();
        String[] lines = html.split("\n");
        if (lines.length > 0 && lines[0].startsWith("<!--")) {
            for (int i = 1; i < lines.length && !lines[i].startsWith("-->"); ++i) {
                String line = lines[i];
                String[] split = line.split(":");
                if (split.length != 2) continue;
                String key = split[0].trim();
                String value = split[1].trim();
                frontMatter.put(key, List.of(value));
            }
        }
        return frontMatter;
    }
}

