/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.jonathangiles.tools.sitebuilder.models.Post;
import net.jonathangiles.tools.sitebuilder.models.SiteContentStatus;
import net.jonathangiles.tools.sitebuilder.models.input.InputFile;

public class SiteContent {
    @JsonProperty(value="Title")
    private String title;
    @JsonProperty(value="Content")
    @JacksonXmlCData
    private String content;
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonProperty(value="Slug")
    private String slug;
    @JsonProperty(value="Status")
    private SiteContentStatus status;
    @JsonProperty(value="Template")
    private String template;
    @JsonIgnore
    private String relativePath;
    @JsonIgnore
    private Path fullOutputPath;
    @JsonIgnore
    private final Map<String, String> properties = new HashMap<String, String>();

    public SiteContent() {
    }

    public SiteContent(InputFile inputFile) {
        this.setContent(inputFile.getBody());
        inputFile.getFrontMatterValue("title").ifPresent(this::setTitle);
        inputFile.getFrontMatterValue("date").ifPresent(d -> this.setDate(LocalDate.parse(d)));
        inputFile.getFrontMatterValue("slug").ifPresent(this::setSlug);
        inputFile.getFrontMatterValue("template").ifPresent(this::setTemplate);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.properties.put("title", title);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.properties.put("content", content);
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
        this.properties.put("date", date.toString());
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
        this.properties.put("slug", slug);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public SiteContentStatus getStatus() {
        return this.status;
    }

    public void setStatus(SiteContentStatus status) {
        this.status = status;
        this.properties.put("status", status.toString());
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
        this.properties.put("relativePath", relativePath);
    }

    public Path getFullOutputPath() {
        return this.fullOutputPath;
    }

    public void setFullOutputPath(Path fullOutputPath) {
        this.fullOutputPath = fullOutputPath;
        this.properties.put("fullOutputPath", fullOutputPath.toString());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Post post = (Post)o;
        return this.getDate().equals(post.getDate()) && this.getSlug().equals(post.getSlug());
    }

    public int hashCode() {
        return Objects.hash(this.getDate(), this.getSlug());
    }
}

