/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jonathangiles.tools.sitebuilder.models.Page;
import net.jonathangiles.tools.sitebuilder.models.Post;
import net.jonathangiles.tools.sitebuilder.models.SiteContent;
import net.jonathangiles.tools.sitebuilder.models.SiteContentStatus;
import net.jonathangiles.tools.sitebuilder.models.input.InputFile;
import net.jonathangiles.tools.sitebuilder.util.FileUtils;
import net.jonathangiles.tools.sitebuilder.util.SitePaths;

public abstract class SiteBuilder {
    public static final String OUTPUT_PATH = "target/output";
    public static final File OUTPUT_DIR = new File("target/output");
    private final ClassLoader loader;
    private Map<String, String> templates = new HashMap<String, String>();
    private final Map<String, SiteContent> allContentMap = new HashMap<String, SiteContent>();
    private final Consumer<SiteContent> postPathFunction = SitePaths.createSlugDirStructure("posts/", true);
    private final Consumer<SiteContent> pagePathFunction = SitePaths.createSlugDirStructure("", false);

    protected SiteBuilder() {
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    public void init() {
        this.loadTemplates();
        this.processIncludesDirectives();
        this.registerContent();
    }

    public void run() {
        this.processContent();
        this.processStaticResources();
    }

    private void registerContent() {
        this.registerContent(FileUtils.getPath("www/pages", this.loader), ContentType.PAGE);
        this.registerContent(FileUtils.getPath("www/posts", this.loader), ContentType.POST);
    }

    private void registerContent(Path rootPath, ContentType type) {
        try (Stream<Path> files = Files.walk(rootPath, new FileVisitOption[0]);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                String n = path.getFileName().toString();
                return n.endsWith(".html") || n.endsWith(".md") || n.endsWith(".xml");
            }).map(InputFile::fromPath).filter(InputFile::hasFrontMatter).forEach(inputFile -> {
                switch (type.ordinal()) {
                    case 0: {
                        this.registerContent(new Page((InputFile)inputFile));
                        break;
                    }
                    case 1: {
                        this.registerContent(new Post((InputFile)inputFile));
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerContent(SiteContent content) {
        if (content instanceof Page) {
            this.pagePathFunction.accept(content);
        } else if (content instanceof Post) {
            this.postPathFunction.accept(content);
        }
        if (this.allContentMap.containsKey(content.getSlug())) {
            System.err.println("Duplicate slug found '" + content.getSlug() + "' - aborting");
            System.exit(-1);
        }
        this.allContentMap.put(content.getSlug(), content);
    }

    public Set<Post> getAllPosts() {
        return this.allContentMap.values().stream().filter(c -> c instanceof Post).map(c -> (Post)c).sorted(Comparator.comparing(SiteContent::getDate).reversed().thenComparing(SiteContent::getSlug)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void processStaticResources() {
        Path staticPath = FileUtils.getPath("www/static", this.loader);
        try (Stream<Path> files = Files.walk(staticPath, new FileVisitOption[0]);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> FileUtils.copyFile(staticPath, file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processContent() {
        this.allContentMap.values().stream().filter(c -> c.getStatus() != SiteContentStatus.DRAFT).forEach(content -> {
            System.out.println("Processing: " + content.getSlug());
            this.processContent((SiteContent)content);
        });
    }

    private void processContent(SiteContent siteContent) {
        String template = siteContent.getTemplate();
        String html = this.processIncludesDirectives(this.templates.getOrDefault(template, siteContent.getContent()));
        for (Map.Entry<String, String> property : siteContent.getProperties().entrySet()) {
            html = SiteBuilder.fillTemplate(html, property.getKey(), property.getValue());
        }
        Path outputPath = siteContent.getFullOutputPath();
        outputPath.getParent().toFile().mkdirs();
        FileUtils.writeToFile(outputPath, html);
    }

    private void loadTemplates() {
        Path templatesPath = FileUtils.getPath("www/templates", this.loader);
        try (Stream<Path> files = Files.walk(templatesPath, new FileVisitOption[0]);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String filename = file.getFileName().toString();
                System.out.println("Reading template: " + filename);
                this.templates.put(filename.substring(0, filename.lastIndexOf(".")), FileUtils.readFile(file));
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processIncludesDirectives() {
        this.templates.replaceAll((k, v) -> this.processIncludesDirectives((String)v));
    }

    private String processIncludesDirectives(String html) {
        for (Map.Entry<String, String> template : this.templates.entrySet()) {
            html = SiteBuilder.fillTemplate(html, "include " + template.getKey(), template.getValue());
        }
        return html;
    }

    private static String fillTemplate(String html, String field, String data) {
        return SiteBuilder.fillTemplate(html, field, data, null);
    }

    private static String fillTemplate(String html, String field, String data, Post post) {
        try {
            data = data.replace("$", "\\$");
            return html.replaceAll(Pattern.quote("${" + field + "}"), data);
        }
        catch (IndexOutOfBoundsException e) {
            if (post == null) {
                throw new RuntimeException(e);
            }
            System.err.println("Could not do regex on field '" + field + "' on post '" + post.getTitle() + "' with data '" + data + "'");
            return "";
        }
    }

    private static enum ContentType {
        PAGE,
        POST;

    }
}

