/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import net.jonathangiles.tools.sitebuilder.SiteBuilder;
import net.jonathangiles.tools.sitebuilder.models.Post;

public class SitePaths {
    private SitePaths() {
    }

    public static Path createRelativePath(Path basePath, Path file) {
        return new File(SiteBuilder.OUTPUT_DIR, basePath.relativize(file).toString()).toPath();
    }

    public static String createRelativePath(Path path) {
        String pathStr = path.toString();
        return pathStr.substring(pathStr.indexOf("output/") + "output".length() + 1);
    }

    public static Function<PostPathRequest, PostPath> recreateDirStructure() {
        return postPathRequest -> {
            Path basePath = ((PostPathRequest)postPathRequest).baseOutputPath;
            Post post = ((PostPathRequest)postPathRequest).post;
            Path relativePath = Paths.get(SitePaths.createRelativePath(basePath.getParent(), ((PostPathRequest)postPathRequest).pathToPostFile).toString(), post.getSlug());
            Path fullOutputPath = Paths.get(relativePath.getParent().toString(), "index.html");
            return new PostPath(post, relativePath.toString(), fullOutputPath);
        };
    }

    public static Function<PostPathRequest, PostPath> createSlugDirStructure(String prefix, boolean createYearDirs) {
        return postPathRequest -> {
            Path basePath = ((PostPathRequest)postPathRequest).baseOutputPath;
            Post post = ((PostPathRequest)postPathRequest).post;
            String relativePath = prefix + (String)(createYearDirs ? post.getDate().getYear() + "/" : "") + post.getSlug();
            Path fullOutputPath = new File(SiteBuilder.OUTPUT_DIR, relativePath + "/index.html").toPath();
            return new PostPath(post, relativePath, fullOutputPath);
        };
    }

    public static class PostPathRequest {
        private final Post post;
        private final Path baseOutputPath;
        private final Path pathToPostFile;

        public PostPathRequest(Post post, Path pathToPostFile, Path baseOutputPath) {
            this.post = post;
            this.pathToPostFile = pathToPostFile;
            this.baseOutputPath = baseOutputPath;
        }
    }

    public static class PostPath {
        private final Post post;
        private final String relativePath;
        private final Path fullOutputPath;

        public PostPath(Post post, String relativePath, Path fullOutputPath) {
            this.post = post;
            this.relativePath = relativePath;
            this.fullOutputPath = fullOutputPath;
        }

        public Post getPost() {
            return this.post;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public Path getFullOutputPath() {
            return this.fullOutputPath;
        }
    }
}

