/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.jonathangiles.tools.sitebuilder.models.Page;
import net.jonathangiles.tools.sitebuilder.models.Post;
import net.jonathangiles.tools.sitebuilder.models.PostStatus;
import net.jonathangiles.tools.sitebuilder.util.SitePaths;
import org.commonmark.ext.front.matter.YamlFrontMatterExtension;
import org.commonmark.ext.front.matter.YamlFrontMatterVisitor;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public abstract class SiteBuilder {
    public static final String OUTPUT_PATH = "output";
    public static final File OUTPUT_DIR = new File("output");
    private final ClassLoader loader;
    private Map<String, String> templates;
    private SortedSet<Post> allPosts;
    private Map<String, Post> allPostsMap;
    private Map<String, Page> allPagesMap;
    private Function<SitePaths.PostPathRequest, SitePaths.PostPath> postPathFunction = SitePaths.createSlugDirStructure("posts/", true);

    protected SiteBuilder() {
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    public void setPostPathFunction(Function<SitePaths.PostPathRequest, SitePaths.PostPath> postPathFunction) {
        this.postPathFunction = postPathFunction;
    }

    public void run() {
        this.templates = new HashMap<String, String>();
        this.loadTemplates();
        this.processIncludesDirectives();
        this.allPosts = new TreeSet<Post>(Comparator.comparing(Post::getDate).reversed().thenComparing(Post::getSlug));
        this.allPostsMap = new HashMap<String, Post>();
        this.processPosts();
        this.allPagesMap = new HashMap<String, Page>();
        this.registerPages();
        this.processPages();
        this.processStaticResources();
    }

    protected void registerPages() {
    }

    protected void registerPage(Page page) {
        this.allPagesMap.put(page.getName(), page);
    }

    protected Set<Post> getAllPosts() {
        return Collections.unmodifiableSortedSet(this.allPosts);
    }

    protected Map<String, Post> getAllPostsMap() {
        return Collections.unmodifiableMap(this.allPostsMap);
    }

    private void processPosts() {
        try {
            Path postsPath = SiteBuilder.getPath("www/posts", this.loader);
            Files.walk(postsPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                String filename = path.getFileName().toString();
                return filename.endsWith(".xml") || filename.endsWith(".md");
            }).forEach(postFile -> this.processPost(postsPath, (Path)postFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processPost(Path basePath, Path postFile) {
        String filename = postFile.getFileName().toString();
        try {
            Post post = null;
            if (filename.endsWith(".xml")) {
                ObjectMapper xmlMapper = new XmlMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JavaTimeModule());
                post = (Post)xmlMapper.readValue(postFile.toFile(), Post.class);
            } else if (filename.endsWith(".md")) {
                Parser parser = Parser.builder().extensions(Arrays.asList(YamlFrontMatterExtension.create())).build();
                Node document = parser.parseReader((Reader)new FileReader(postFile.toFile()));
                YamlFrontMatterVisitor frontMatter = new YamlFrontMatterVisitor();
                document.accept((Visitor)frontMatter);
                HtmlRenderer renderer = HtmlRenderer.builder().build();
                post = new Post();
                post.setContent(renderer.render(document));
                post.setSlug((String)((List)frontMatter.getData().get("slug")).get(0));
                post.setTitle((String)((List)frontMatter.getData().get("title")).get(0));
                post.setDate(LocalDate.parse((CharSequence)((List)frontMatter.getData().get("date")).get(0)));
            } else {
                throw new RuntimeException("Cannot process post file: " + postFile);
            }
            if (post.getStatus() == PostStatus.DRAFT) {
                return;
            }
            System.out.println("Processing post: " + post.getSlug());
            if (this.allPostsMap.containsKey(post.getSlug())) {
                System.err.println("Duplicate slug found '" + post.getSlug() + "' - aborting");
                System.exit(-1);
            }
            this.allPosts.add(post);
            this.allPostsMap.put(post.getSlug(), post);
            String html = this.templates.get("post");
            SitePaths.PostPath postPath = this.postPathFunction.apply(new SitePaths.PostPathRequest(post, postFile, basePath));
            String relativePath = postPath.getRelativePath();
            post.setRelativePath(relativePath);
            for (Map.Entry entry : this.getPostProperties(post).entrySet()) {
                html = SiteBuilder.fillTemplate(html, (String)entry.getKey(), (String)entry.getValue());
            }
            Path postOutputPath = postPath.getFullOutputPath();
            postOutputPath.getParent().toFile().mkdirs();
            SiteBuilder.writeToFile(postOutputPath, html);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Map<String, String> getPostProperties(Post post) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("title", post.getTitle());
        properties.put("content", post.getContent());
        properties.put("date", post.getDate().toString());
        properties.put("path", post.getRelativePath());
        return properties;
    }

    private void processPages() {
        try {
            Path pagesPath = SiteBuilder.getPath("www/pages", this.loader);
            Files.walk(pagesPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                Path path = SitePaths.createRelativePath(pagesPath, file);
                System.out.println("Processing page: " + path);
                String html = this.processIncludesDirectives(SiteBuilder.readFile(file));
                String filename = path.getFileName().toString();
                String pageName = filename.substring(0, filename.lastIndexOf("."));
                Page page = this.allPagesMap.get(pageName);
                for (Map.Entry<String, String> entry : this.getPageProperties(page, path).entrySet()) {
                    html = SiteBuilder.fillTemplate(html, entry.getKey(), entry.getValue());
                }
                path.toFile().getParentFile().mkdirs();
                SiteBuilder.writeToFile(path, html);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Map<String, String> getPageProperties(Page page, Path pagePath) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (page != null) {
            properties.putAll(page.getProperties());
        }
        properties.put("path", SitePaths.createRelativePath(pagePath));
        return properties;
    }

    private void processStaticResources() {
        try {
            Path staticPath = SiteBuilder.getPath("www/static", this.loader);
            Files.walk(staticPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> SiteBuilder.copyFile(staticPath, file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadTemplates() {
        Path templatesPath = SiteBuilder.getPath("www/templates", this.loader);
        try {
            Files.walk(templatesPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String filename = file.getFileName().toString();
                System.out.println("Reading template: " + filename);
                this.templates.put(filename.substring(0, filename.lastIndexOf(".")), SiteBuilder.readFile(file));
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processIncludesDirectives() {
        this.templates.replaceAll((k, v) -> this.processIncludesDirectives((String)v));
    }

    private String processIncludesDirectives(String html) {
        for (Map.Entry<String, String> template : this.templates.entrySet()) {
            html = SiteBuilder.fillTemplate(html, "include " + template.getKey(), template.getValue());
        }
        return html;
    }

    private static String fillTemplate(String html, String field, String data) {
        return SiteBuilder.fillTemplate(html, field, data, null);
    }

    private static String fillTemplate(String html, String field, String data, Post post) {
        try {
            data = data.replace("$", "\\$");
            return html.replaceAll(Pattern.quote("${" + field + "}"), data);
        }
        catch (IndexOutOfBoundsException e) {
            if (post == null) {
                e.printStackTrace();
            } else {
                System.err.println("Could not do regex on field '" + field + "' on post '" + post.getTitle() + "' with data '" + data + "'");
            }
            return "";
        }
    }

    private static Path getPath(String path, ClassLoader loader) {
        return new File(loader.getResource(path).getFile()).toPath();
    }

    private static void writeToFile(Path file, String content) {
        try {
            Files.write(file, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyFile(Path basePath, Path file) {
        try {
            Path newPath = SitePaths.createRelativePath(basePath, file);
            System.out.println("Copying static file: " + newPath);
            newPath.toFile().mkdirs();
            Files.copy(file, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String readFile(Path file) {
        StringBuilder sb = new StringBuilder();
        try {
            Files.lines(file, StandardCharsets.UTF_8).forEach(line -> sb.append((String)line).append("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

