/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.jonathangiles.tools.sitebuilder.models.Page;
import net.jonathangiles.tools.sitebuilder.models.Post;
import net.jonathangiles.tools.sitebuilder.models.PostStatus;

public abstract class SiteBuilder {
    private static final File OUTPUT_DIR = new File("output");
    private final ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private Map<String, String> templates;
    private SortedSet<Post> allPosts;
    private Map<String, Post> allPostsMap;
    private Map<String, Page> allPagesMap;

    protected SiteBuilder() {
    }

    public void run() {
        this.templates = new HashMap<String, String>();
        this.loadTemplates();
        this.processIncludesDirectives();
        this.allPosts = new TreeSet<Post>(Comparator.comparing(Post::getDate).reversed().thenComparing(Post::getSlug));
        this.allPostsMap = new HashMap<String, Post>();
        this.processPosts();
        this.allPagesMap = new HashMap<String, Page>();
        this.registerPages();
        this.processPages();
        this.processStaticResources();
    }

    protected void registerPages() {
    }

    protected void registerPage(Page page) {
        this.allPagesMap.put(page.getName(), page);
    }

    protected Set<Post> getAllPosts() {
        return Collections.unmodifiableSortedSet(this.allPosts);
    }

    protected Map<String, Post> getAllPostsMap() {
        return Collections.unmodifiableMap(this.allPostsMap);
    }

    private void processPosts() {
        try {
            Path postsPath = Paths.get(this.loader.getResource("www/posts").getPath(), new String[0]);
            Files.walk(postsPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().contains("index.xml")).forEach(indexXmlFile -> this.processPost(postsPath, (Path)indexXmlFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processPost(Path basePath, Path indexXmlFile) {
        try {
            ObjectMapper xmlMapper = new XmlMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JavaTimeModule());
            Post post = (Post)xmlMapper.readValue(indexXmlFile.toFile(), Post.class);
            if (post.getStatus() == PostStatus.DRAFT) {
                return;
            }
            Path relativePath = SiteBuilder.createRelativePath(basePath.getParent(), indexXmlFile);
            post.setRelativePath(relativePath);
            System.out.println("Processing post: " + post.getSlug());
            if (this.allPostsMap.containsKey(post.getSlug())) {
                System.err.println("Duplicate slug found '" + post.getSlug() + "' - aborting");
                System.exit(-1);
            }
            this.allPosts.add(post);
            this.allPostsMap.put(post.getSlug(), post);
            String html = this.templates.get("post");
            html = SiteBuilder.fillTemplate(html, "relativeToRoot", "../../");
            html = SiteBuilder.fillTemplate(html, "title", post.getTitle());
            html = SiteBuilder.fillTemplate(html, "content", post.getContent());
            html = SiteBuilder.fillTemplate(html, "date", post.getDate().toString());
            relativePath.toFile().getParentFile().mkdirs();
            SiteBuilder.writeToFile(Paths.get(relativePath.getParent().toString(), "index.html"), html);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processPages() {
        try {
            Path pagesPath = Paths.get(this.loader.getResource("www/pages").getPath(), new String[0]);
            Files.walk(pagesPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                Path path = SiteBuilder.createRelativePath(pagesPath, file);
                System.out.println("Processing page: " + path);
                String html = this.processIncludesDirectives(SiteBuilder.readFile(file));
                int count = (int)path.toString().chars().filter(ch -> ch == 47).count() - 1;
                html = SiteBuilder.fillTemplate(html, "relativeToRoot", SiteBuilder.buildRelative(count));
                String filename = path.getFileName().toString();
                String pageName = filename.substring(0, filename.lastIndexOf("."));
                if (this.allPagesMap.containsKey(pageName)) {
                    Page page = this.allPagesMap.get(pageName);
                    for (Map.Entry<String, String> entry : page.getValues().entrySet()) {
                        html = SiteBuilder.fillTemplate(html, entry.getKey(), entry.getValue());
                    }
                }
                path.toFile().getParentFile().mkdirs();
                SiteBuilder.writeToFile(path, html);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processStaticResources() {
        try {
            Path staticPath = Paths.get(this.loader.getResource("www/static").getPath(), new String[0]);
            Files.walk(staticPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> SiteBuilder.copyFile(staticPath, file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadTemplates() {
        Path templatesPath = Paths.get(this.loader.getResource("www/templates").getPath(), new String[0]);
        try {
            Files.walk(templatesPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String filename = file.getFileName().toString();
                System.out.println("Reading template: " + filename);
                this.templates.put(filename.substring(0, filename.lastIndexOf(".")), SiteBuilder.readFile(file));
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processIncludesDirectives() {
        this.templates.replaceAll((k, v) -> this.processIncludesDirectives((String)v));
    }

    private String processIncludesDirectives(String html) {
        for (Map.Entry<String, String> template : this.templates.entrySet()) {
            html = SiteBuilder.fillTemplate(html, "include " + template.getKey(), template.getValue());
        }
        return html;
    }

    private static String fillTemplate(String html, String field, String data) {
        return SiteBuilder.fillTemplate(html, field, data, null);
    }

    private static String fillTemplate(String html, String field, String data, Post post) {
        try {
            data = data.replace("$", "\\$");
            return html.replaceAll(Pattern.quote("${" + field + "}"), data);
        }
        catch (IndexOutOfBoundsException e) {
            if (post == null) {
                e.printStackTrace();
            } else {
                System.err.println("Could not do regex on field '" + field + "' on post '" + post.getTitle() + "' with data '" + data + "'");
            }
            return "";
        }
    }

    private static void writeToFile(Path file, String content) {
        try {
            Files.write(file, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Path createRelativePath(Path basePath, Path file) {
        return new File(OUTPUT_DIR, basePath.relativize(file).toString()).toPath();
    }

    private static void copyFile(Path basePath, Path file) {
        try {
            Path newPath = SiteBuilder.createRelativePath(basePath, file);
            System.out.println("Copying static file: " + newPath);
            newPath.toFile().mkdirs();
            Files.copy(file, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String readFile(Path file) {
        StringBuilder sb = new StringBuilder();
        try {
            Files.lines(file, StandardCharsets.UTF_8).forEach(line -> sb.append((String)line).append("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static String buildRelative(int count) {
        String s = "";
        for (int i = 0; i < count; ++i) {
            s = s + "../";
        }
        return s;
    }
}

