/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.jclib;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.jomcraft.jclib.ConfigFile;
import net.jomcraft.jclib.JCLib;

public class MySQL {
    private static String HOST = "";
    private String DATABASE = "";
    private static String USER = "";
    private static String PASSWORD = "";
    public Connection con;

    public MySQL(String host, String database, String user, String password) throws ClassNotFoundException, SQLException {
        HOST = host;
        this.DATABASE = database;
        USER = user;
        PASSWORD = password;
        this.connect();
    }

    public void connect() throws ClassNotFoundException, SQLException {
        Class.forName("net.jomcraft.org.mariadb.jdbc.Driver");
        this.con = DriverManager.getConnection("jdbc:mariadb://" + HOST + ":" + (String)ConfigFile.COMMON.port.get() + "/" + this.DATABASE + "?autoReconnect=true&characterEncoding=utf-8", USER, PASSWORD);
    }

    public void close() {
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (SQLException e) {
            JCLib.getLog().error("Couldn't close the MySQL-connection: ", (Throwable)e);
        }
    }

    public void update(String qry) throws ClassNotFoundException, SQLException {
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(qry);
        }
        catch (SQLException e) {
            if (e.getMessage().startsWith("Could not create")) {
                JCLib.getLog().error("Couldn't send and update: ", (Throwable)e);
            }
            this.connect();
        }
    }

    public ResultSet query(String qry) throws ClassNotFoundException, SQLException {
        ResultSet rs = null;
        try (Statement st = this.con.createStatement();){
            rs = st.executeQuery(qry);
        }
        catch (SQLException e) {
            if (e.getMessage().startsWith("Could not create")) {
                JCLib.getLog().error("Couldn't send a query: ", (Throwable)e);
            }
            this.connect();
        }
        return rs;
    }
}

