/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.jclib;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlParser;
import com.google.common.eventbus.EventBus;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.jomcraft.jclib.ConfigFile;
import net.jomcraft.jclib.ConnectionRequest;
import net.jomcraft.jclib.DBRequestHandler;
import net.jomcraft.jclib.EventHandlers;
import net.jomcraft.jclib.JCLibConnectionRequest;
import net.jomcraft.jclib.MySQL;
import net.jomcraft.jclib.events.DBConnectEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jclib")
public class JCLib {
    public static final String MODID = "jclib";
    private static final Logger log = LogManager.getLogger((String)"jclib");
    public static final String VERSION = JCLib.getModVersion();
    static Timer keepaliveTimer = new Timer();
    static HashMap<String, Boolean> shutdownState = new HashMap();
    private static boolean keepaliveActivated = false;
    public static EventBus eventBus = new EventBus();
    private static HashMap<String, ConnectionRequest> connectionRequests = new HashMap();
    private static HashMap<String, DBRequestHandler> requestHandlers = new HashMap();
    static MySQL mysql;
    private static JCLib instance;

    public JCLib() {
        instance = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigFile.COMMON_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
        String any = "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31";
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::postInit);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (test2, test) -> true));
    }

    public static void communicateLogin(String modid) {
        JCLib.getLog().info(modid + " has been added to the tracking system");
        shutdownState.put(modid, false);
    }

    public static void readyForShutdown(String modid) {
        shutdownState.put(modid, true);
        for (boolean state : shutdownState.values()) {
            if (state) continue;
            return;
        }
        JCLib.getLog().info("Sent shutdown request to child handlers");
        requestHandlers.values().forEach(db -> db.shutdown());
        JCLib.getLog().info("MySQL service shut down");
        keepaliveTimer.cancel();
    }

    public void postInit(FMLLoadCompleteEvent event) {
        if (((Boolean)ConfigFile.COMMON.only_server.get()).booleanValue()) {
            DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
                connectionRequests.put(MODID, new ConnectionRequest("JCLib", new JCLibConnectionRequest()));
                for (Map.Entry<String, ConnectionRequest> db : connectionRequests.entrySet()) {
                    String modid = db.getKey();
                    ConnectionRequest request = db.getValue();
                    MySQL connection = JCLib.connectMySQL(request.getDbName());
                    if (connection == null) continue;
                    DBRequestHandler handler = request.getHandler().establishCon(connection);
                    requestHandlers.put(modid, handler);
                }
                connectionRequests.clear();
            });
        } else {
            connectionRequests.put(MODID, new ConnectionRequest("JCLib", new JCLibConnectionRequest()));
            for (Map.Entry<String, ConnectionRequest> db : connectionRequests.entrySet()) {
                String modid = db.getKey();
                ConnectionRequest request = db.getValue();
                MySQL connection = JCLib.connectMySQL(request.getDbName());
                if (connection == null) continue;
                DBRequestHandler handler = request.getHandler().establishCon(connection);
                requestHandlers.put(modid, handler);
            }
            connectionRequests.clear();
        }
    }

    public static MySQL connectMySQL(String dbName) {
        try {
            JCLib.getLog().info("Attempting to connect to the MySQL database: " + dbName);
            MySQL connection = new MySQL((String)ConfigFile.COMMON.hostIP.get(), dbName, (String)ConfigFile.COMMON.username.get(), (String)ConfigFile.COMMON.password.get());
            eventBus.post((Object)new DBConnectEvent(dbName, Event.Result.ALLOW));
            return connection;
        }
        catch (Exception e) {
            JCLib.getLog().error("Couldn't connect to the MySQL database " + dbName + ": ", (Throwable)e);
            eventBus.post((Object)new DBConnectEvent(dbName, Event.Result.DENY));
            return null;
        }
    }

    public static String getModVersion() {
        TomlParser parser = new TomlParser();
        InputStream stream = JCLib.class.getClassLoader().getResourceAsStream("META-INF/mods.toml");
        CommentedConfig file = (CommentedConfig)parser.parse(stream);
        return (String)((CommentedConfig)((ArrayList)file.get("mods")).get(0)).get("version");
    }

    public static boolean startKeepAlive(int minutes) {
        if (!keepaliveActivated) {
            JCLib.getLog().info("Activated keep-alive task");
            keepaliveTimer.scheduleAtFixedRate((TimerTask)new KeepAlive(), minutes * 60 * 1000, (long)(minutes * 60 * 1000));
            keepaliveActivated = true;
            return true;
        }
        return false;
    }

    public static void putConnectionRequest(String modid, ConnectionRequest request) {
        if (!connectionRequests.containsKey(modid)) {
            connectionRequests.put(modid, request);
        }
    }

    public static HashMap<String, DBRequestHandler> getRequestHandlers() {
        return requestHandlers;
    }

    public static JCLib getInstance() {
        return instance;
    }

    public static Logger getLog() {
        return log;
    }

    public static class KeepAlive
    extends TimerTask {
        @Override
        public void run() {
            if (requestHandlers.containsKey(JCLib.MODID)) {
                ((DBRequestHandler)requestHandlers.get(JCLib.MODID)).sendVoidQuery("SELECT VERSION();");
            } else if (requestHandlers.size() > 1) {
                ((DBRequestHandler)requestHandlers.values().iterator().next()).sendVoidQuery("SELECT VERSION();");
            }
        }
    }
}

