/*
 * Decompiled with CFR 0.152.
 */
package net.jokubasdargis.rxbus;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import net.jokubasdargis.rxbus.Flushable;
import net.jokubasdargis.rxbus.Flusher;
import rx.Scheduler;
import rx.functions.Action0;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;

final class DefaultFlusher
implements Flusher {
    private final Scheduler scheduler;
    private final long flushDelayNanos;
    private final Deque<Flushable> flushables = new ConcurrentLinkedDeque<Flushable>();
    private final FlushAction flushAction = new FlushAction();
    private final SerialSubscription subscription = new SerialSubscription();

    static Flusher create(Scheduler scheduler, long flushDelay, TimeUnit flushDelayUnit) {
        return new DefaultFlusher(scheduler, flushDelay, flushDelayUnit);
    }

    private DefaultFlusher(Scheduler scheduler, long flushDelay, TimeUnit flushDelayUnit) {
        this.scheduler = scheduler;
        this.flushDelayNanos = flushDelayUnit.toNanos(flushDelay);
        this.resetSubscription();
    }

    @Override
    public void schedule(Flushable flushable) {
        this.flushables.add(flushable);
        this.scheduleFlush();
    }

    private void scheduleFlush() {
        if (this.subscription.get() == Subscriptions.unsubscribed()) {
            this.subscription.set(this.scheduler.createWorker().schedule((Action0)this.flushAction, this.flushDelayNanos, TimeUnit.NANOSECONDS));
        }
    }

    private void resetSubscription() {
        this.subscription.set(Subscriptions.unsubscribed());
    }

    private class FlushAction
    implements Action0 {
        private FlushAction() {
        }

        public void call() {
            while (!DefaultFlusher.this.flushables.isEmpty()) {
                Flushable flushable = (Flushable)DefaultFlusher.this.flushables.remove();
                flushable.flush();
                DefaultFlusher.this.resetSubscription();
            }
        }
    }
}

