/*
 * Decompiled with CFR 0.152.
 */
package net.jokubasdargis.rxbus;

import java.util.concurrent.TimeUnit;
import net.jokubasdargis.rxbus.Bus;
import net.jokubasdargis.rxbus.DefaultDispatcher;
import net.jokubasdargis.rxbus.DefaultFlusher;
import net.jokubasdargis.rxbus.Dispatcher;
import net.jokubasdargis.rxbus.ErrorListener;
import net.jokubasdargis.rxbus.RxBus;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public final class RxBusDispatcher {
    public static Builder builder() {
        return new Builder();
    }

    private RxBusDispatcher() {
        throw new AssertionError((Object)"No instances");
    }

    public static final class Builder {
        private static final long DEFAULT_FLUSH_DELAY_MIN = 2L;
        private Bus bus;
        private Scheduler busScheduler;
        private Scheduler flushScheduler;
        private long flushDelay;
        private TimeUnit flushDelayTimeUnit;
        private ErrorListener errorListener;

        Builder() {
        }

        public Builder bus(Bus bus) {
            if (bus == null) {
                throw new NullPointerException("bus == null");
            }
            this.bus = bus;
            return this;
        }

        public Builder busScheduler(Scheduler scheduler) {
            if (scheduler == null) {
                throw new NullPointerException("scheduler == null");
            }
            this.busScheduler = scheduler;
            return this;
        }

        public Builder flushScheduler(Scheduler scheduler) {
            if (scheduler == null) {
                throw new NullPointerException("scheduler == null");
            }
            this.flushScheduler = scheduler;
            return this;
        }

        public Builder flushDelay(long flushDelay, TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit == null");
            }
            this.flushDelay = flushDelay;
            this.flushDelayTimeUnit = timeUnit;
            return this;
        }

        public Builder errorListener(ErrorListener errorListener) {
            if (errorListener == null) {
                throw new NullPointerException("errorListener == null");
            }
            this.errorListener = errorListener;
            return this;
        }

        public Dispatcher build() {
            if (this.bus == null) {
                this.bus = RxBus.create();
            }
            if (this.busScheduler == null) {
                this.busScheduler = Schedulers.immediate();
            }
            if (this.flushScheduler == null) {
                this.flushScheduler = Schedulers.io();
            }
            if (this.flushDelayTimeUnit == null) {
                this.flushDelay = 2L;
                this.flushDelayTimeUnit = TimeUnit.MINUTES;
            }
            if (this.errorListener == null) {
                this.errorListener = ErrorListener.NOOP;
            }
            return DefaultDispatcher.create(this.bus, this.busScheduler, DefaultFlusher.create(this.flushScheduler, this.flushDelay, this.flushDelayTimeUnit), this.errorListener);
        }
    }
}

