/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.riot.league;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.List;
import java.util.Map;
import net.joelinn.riot.AbstractClient;
import net.joelinn.riot.Region;
import net.joelinn.riot.constants.SubType;
import net.joelinn.riot.league.dto.League;

public class LeagueClient
extends AbstractClient {
    public LeagueClient(String apiKey, Region region) {
        super(apiKey, region);
    }

    @Override
    protected String getVersion() {
        return "2.4";
    }

    public League getChallengerLeague(SubType type) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("type", (Object)type);
        return (League)this.get("challenger", params).getEntity(League.class);
    }

    public Map<String, List<League>> getLeagueEntryBySummoner(long ... summonerIds) {
        return (Map)this.get(String.format("by-summoner/%s/entry", this.commaDelimit(summonerIds))).getEntity((GenericType)new GenericType<Map<String, List<League>>>(){});
    }

    public Map<String, List<League>> getLeaguesBySummoner(long ... summonerIds) {
        return (Map)this.get(String.format("by-summoner/%s", this.commaDelimit(summonerIds))).getEntity((GenericType)new GenericType<Map<String, List<League>>>(){});
    }

    public Map<String, List<League>> getLeaguesByTeam(String ... teamIds) {
        return (Map)this.get("by-team/" + this.commaDelimit(teamIds)).getEntity((GenericType)new GenericType<Map<String, List<League>>>(){});
    }

    public Map<String, List<League>> getLeagueEntriesByTeam(String ... teamIds) {
        return (Map)this.get(String.format("by-team/%s/entry", this.commaDelimit(teamIds))).getEntity((GenericType)new GenericType<Map<String, List<League>>>(){});
    }

    @Override
    protected ClientResponse request(String method, String url, MultivaluedMapImpl queryParams, MultivaluedMapImpl data) {
        return super.request(method, "league/" + url, queryParams, data);
    }
}

