/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.riot.staticdata;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Arrays;
import net.joelinn.riot.AbstractClient;
import net.joelinn.riot.Region;
import net.joelinn.riot.staticdata.ChampData;
import net.joelinn.riot.staticdata.ItemData;
import net.joelinn.riot.staticdata.ItemListData;
import net.joelinn.riot.staticdata.MasteryData;
import net.joelinn.riot.staticdata.MasteryListData;
import net.joelinn.riot.staticdata.RuneData;
import net.joelinn.riot.staticdata.RuneListData;
import net.joelinn.riot.staticdata.SpellData;
import net.joelinn.riot.staticdata.dto.Champion;
import net.joelinn.riot.staticdata.dto.ChampionList;
import net.joelinn.riot.staticdata.dto.Item;
import net.joelinn.riot.staticdata.dto.ItemList;
import net.joelinn.riot.staticdata.dto.Mastery;
import net.joelinn.riot.staticdata.dto.MasteryList;
import net.joelinn.riot.staticdata.dto.Realm;
import net.joelinn.riot.staticdata.dto.Rune;
import net.joelinn.riot.staticdata.dto.RuneList;
import net.joelinn.riot.staticdata.dto.SummonerSpell;
import net.joelinn.riot.staticdata.dto.SummonerSpellList;

public class StaticDataClient
extends AbstractClient {
    public StaticDataClient(String apiKey, Region region) {
        super(apiKey, region);
    }

    @Override
    protected String getVersion() {
        return "1";
    }

    @Override
    protected String getBaseUrl() {
        return super.getBaseUrl() + "static-data/";
    }

    public ChampionList getChampions() {
        return this.getChampions(new ChampData[0]);
    }

    public ChampionList getChampions(ChampData ... champData) {
        return this.getChampions((String)null, (String)null, champData);
    }

    public ChampionList getChampions(String locale, String version, ChampData ... champData) {
        return this.get(ChampionList.class, "champion", locale, version, champData);
    }

    public Champion getChampion(int championId) {
        return this.getChampion(championId, new ChampData[0]);
    }

    public Champion getChampion(int championId, ChampData ... champData) {
        return this.getChampion(championId, (String)null, (String)null, champData);
    }

    public Champion getChampion(int championId, String locale, String version, ChampData ... champData) {
        return this.get(Champion.class, String.format("champion/%s", championId), locale, version, champData);
    }

    public ItemList getItems() {
        return this.getItems(new ItemListData[0]);
    }

    public ItemList getItems(ItemListData ... itemListData) {
        return this.getItems((String)null, (String)null, itemListData);
    }

    public ItemList getItems(String locale, String version, ItemListData ... itemListData) {
        return this.get(ItemList.class, "item", locale, version, itemListData);
    }

    public Item getItem(int itemId) {
        return this.getItem(itemId, new ItemData[0]);
    }

    public Item getItem(int itemId, ItemData ... itemData) {
        return this.getItem(itemId, (String)null, (String)null, itemData);
    }

    public Item getItem(int itemId, String locale, String version, ItemData ... itemData) {
        return this.get(Item.class, String.format("item/%s", itemId), locale, version, itemData);
    }

    public MasteryList getMasteries() {
        return this.getMasteries(new MasteryListData[0]);
    }

    public MasteryList getMasteries(MasteryListData ... masteryListData) {
        return this.getMasteries((String)null, (String)null, masteryListData);
    }

    public MasteryList getMasteries(String locale, String version, MasteryListData ... masteryListData) {
        return this.get(MasteryList.class, "mastery", locale, version, masteryListData);
    }

    public Mastery getMastery(int masteryId) {
        return this.getMastery(masteryId, new MasteryData[0]);
    }

    public Mastery getMastery(int masteryId, MasteryData ... masteryData) {
        return this.getMastery(masteryId, (String)null, (String)null, masteryData);
    }

    public Mastery getMastery(int masteryId, String locale, String version, MasteryData ... masteryData) {
        return this.get(Mastery.class, String.format("mastery/%s", masteryId), version, locale, masteryData);
    }

    public Realm getRealm() {
        return (Realm)this.get("realm").getEntity(Realm.class);
    }

    public RuneList getRunes() {
        return this.getRunes(new RuneListData[0]);
    }

    public RuneList getRunes(RuneListData ... runeListData) {
        return this.getRunes((String)null, (String)null, runeListData);
    }

    public RuneList getRunes(String locale, String version, RuneListData ... runeListData) {
        return this.get(RuneList.class, "rune", locale, version, runeListData);
    }

    public Rune getRune(int runeId) {
        return this.getRune(runeId, new RuneData[0]);
    }

    public Rune getRune(int runeId, RuneData ... runeData) {
        return this.getRune(runeId, (String)null, (String)null, runeData);
    }

    public Rune getRune(int runeId, String locale, String version, RuneData ... runeData) {
        return this.get(Rune.class, String.format("rune/%s", runeId), locale, version, runeData);
    }

    public SummonerSpellList getSummonerSpells() {
        return this.getSummonerSpells(new SpellData[0]);
    }

    public SummonerSpellList getSummonerSpells(SpellData ... spellData) {
        return this.getSummonerSpells((String)null, (String)null, spellData);
    }

    public SummonerSpellList getSummonerSpells(String locale, String version, SpellData ... spellData) {
        return this.get(SummonerSpellList.class, "summoner-spell", locale, version, spellData);
    }

    public SummonerSpell getSummonerSpell(String spellId) {
        return this.getSummonerSpell(spellId, new SpellData[0]);
    }

    public SummonerSpell getSummonerSpell(String spellId, SpellData ... spellData) {
        return this.getSummonerSpell(spellId, (String)null, (String)null, spellData);
    }

    public SummonerSpell getSummonerSpell(String spellId, String locale, String version, SpellData ... spellData) {
        return this.get(SummonerSpell.class, String.format("summoner-spell/%s", spellId), locale, version, spellData);
    }

    protected <T> T get(Class<T> clazz, String url, String locale, String version, Enum ... data) {
        return (T)this.get(url, this.getParams(locale, version, data)).getEntity(clazz);
    }

    protected MultivaluedMapImpl getParams(String locale, String version, Enum ... data) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (data.length > 0) {
            String enumName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, data.getClass().getSimpleName());
            enumName = enumName.substring(0, enumName.length() - 2);
            params.add(enumName, Joiner.on((char)',').skipNulls().join(Arrays.asList(data)));
        }
        if (locale != null) {
            params.add("locale", locale);
        }
        if (version != null) {
            params.add("version", version);
        }
        return params;
    }
}

