/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.riot;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import net.joelinn.riot.ApiException;
import net.joelinn.riot.Error;
import net.joelinn.riot.Region;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AbstractClient {
    protected static final String BASE_URL = "https://prod.api.pvp.net/api/";
    protected String apiKey;
    protected Region region;
    protected WebResource service;

    public AbstractClient(String apiKey, Region region) {
        this.apiKey = apiKey;
        DefaultClientConfig config = new DefaultClientConfig();
        ObjectMapper mapper = new ObjectMapper();
        JacksonJsonProvider provider = new JacksonJsonProvider(mapper);
        config.getSingletons().add(provider);
        Client client = Client.create((ClientConfig)config);
        this.service = client.resource(UriBuilder.fromUri((String)this.getBaseUrl()).build(new Object[0]));
        this.setRegion(region);
    }

    protected String getBaseUrl() {
        return "https://prod.api.pvp.net/api/lol/";
    }

    protected abstract String getVersion();

    public AbstractClient setRegion(Region region) {
        this.region = region;
        return this;
    }

    public Region getRegion() {
        return this.region;
    }

    protected ClientResponse get(String url) {
        return this.get(url, null);
    }

    protected ClientResponse get(String url, MultivaluedMapImpl queryParams) {
        return this.request("GET", url, queryParams);
    }

    protected ClientResponse post(String url, MultivaluedMapImpl data) {
        return this.request("POST", url, null, data);
    }

    protected ClientResponse put(String url, MultivaluedMapImpl data) {
        return this.request("PUT", url, null, data);
    }

    protected ClientResponse delete(String url) {
        return this.request("DELETE", url);
    }

    protected ClientResponse request(String method, String url) {
        return this.request(method, url, null);
    }

    protected ClientResponse request(String method, String url, MultivaluedMapImpl queryParams) {
        return this.request(method, url, queryParams, null);
    }

    protected ClientResponse request(String method, String url, MultivaluedMapImpl queryParams, MultivaluedMapImpl data) {
        if (this.region == null) {
            throw new RuntimeException("region must be set in order to perform api operations!");
        }
        if (queryParams == null) {
            queryParams = new MultivaluedMapImpl();
        }
        queryParams.add("api_key", this.apiKey);
        ClientResponse clientResponse = (ClientResponse)this.getResourceBuilder((Object)((Object)this.region) + "/v" + this.getVersion() + "/" + url, queryParams).method(method, ClientResponse.class, (Object)data);
        this.checkForErrors(clientResponse);
        return clientResponse;
    }

    private void checkForErrors(ClientResponse clientResponse) {
        if (clientResponse.getClientResponseStatus().getStatusCode() != ClientResponse.Status.OK.getStatusCode() && clientResponse.getClientResponseStatus().getStatusCode() != ClientResponse.Status.CREATED.getStatusCode()) {
            ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationConfig.Feature.UNWRAP_ROOT_VALUE, true);
            String message = null;
            try {
                message = ((Error)objectMapper.readValue((String)((String)clientResponse.getEntity(String.class)), Error.class)).message;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw new ApiException(clientResponse.getClientResponseStatus(), message);
        }
    }

    private WebResource.Builder getResourceBuilder(String url, MultivaluedMapImpl queryParams) {
        WebResource webResource = this.service.path(url);
        if (queryParams != null) {
            webResource = webResource.queryParams((MultivaluedMap)queryParams);
        }
        return (WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json");
    }
}

