/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.riot.summoner;

import com.google.common.base.Joiner;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.joelinn.riot.AbstractClient;
import net.joelinn.riot.Region;
import net.joelinn.riot.summoner.dto.MasteryPages;
import net.joelinn.riot.summoner.dto.RunePages;
import net.joelinn.riot.summoner.dto.Summoner;

public class SummonerClient
extends AbstractClient {
    public SummonerClient(String apiKey, Region region) {
        super(apiKey, region);
    }

    @Override
    protected String getVersion() {
        return "1.3";
    }

    public Map<String, MasteryPages> getMasteries(long ... summonerIds) {
        return this.get(String.format("%s/masteries", this.concatenateSummonerIds(summonerIds))).getEntity(new GenericType<Map<String, MasteryPages>>(){});
    }

    public Map<String, RunePages> getRunes(long ... summonerIds) {
        return this.get(String.format("%s/runes", this.concatenateSummonerIds(summonerIds))).getEntity(new GenericType<Map<String, RunePages>>(){});
    }

    public Map<String, Summoner> getSummoner(String ... names) {
        return this.get(String.format("by-name/%s", Joiner.on(',').skipNulls().join(Arrays.asList(names)))).getEntity(new GenericType<Map<String, Summoner>>(){});
    }

    public Map<String, Summoner> getSummoner(long ... summonerIds) {
        return this.get(this.concatenateSummonerIds(summonerIds)).getEntity(new GenericType<Map<String, Summoner>>(){});
    }

    public Map<String, String> getSummonerNames(long ... summonerIds) {
        return this.get(String.format("%s/name", this.concatenateSummonerIds(summonerIds))).getEntity(new GenericType<Map<String, String>>(){});
    }

    @Override
    protected ClientResponse request(String method, String url, MultivaluedMapImpl queryParams, MultivaluedMapImpl data) {
        return super.request(method, "summoner/" + url, queryParams, data);
    }

    protected String concatenateSummonerIds(long ... summonerIds) {
        ArrayList<String> summonerIdStrings = new ArrayList<String>(summonerIds.length);
        for (long summonerId : summonerIds) {
            summonerIdStrings.add(String.valueOf(summonerId));
        }
        return Joiner.on(',').skipNulls().join(summonerIdStrings);
    }
}

