/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.riot;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.joelinn.riot.AbstractClient;
import net.joelinn.riot.Region;
import net.joelinn.riot.champion.ChampionClient;
import net.joelinn.riot.game.GameClient;
import net.joelinn.riot.league.LeagueClient;
import net.joelinn.riot.stats.StatsClient;
import net.joelinn.riot.summoner.SummonerClient;
import net.joelinn.riot.team.TeamClient;

public class Riot {
    protected String apiKey;
    protected Region region;
    protected Map<Class<? extends AbstractClient>, AbstractClient> clients = new HashMap<Class<? extends AbstractClient>, AbstractClient>();

    public Riot(String apiKey) {
        this.apiKey = apiKey;
    }

    public Riot(String apiKey, Region region) {
        this(apiKey);
        this.setRegion(region);
    }

    public Riot setRegion(Region region) {
        this.region = region;
        for (AbstractClient client : this.clients.values()) {
            client.setRegion(region);
        }
        return this;
    }

    protected <T> T getClient(Class<? extends AbstractClient> clazz) {
        if (!this.clients.containsKey(clazz)) {
            try {
                this.clients.put(clazz, clazz.getConstructor(String.class, Region.class).newInstance(new Object[]{this.apiKey, this.region}));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return (T)this.clients.get(clazz);
    }

    public ChampionClient champion() {
        return (ChampionClient)this.getClient(ChampionClient.class);
    }

    public GameClient game() {
        return (GameClient)this.getClient(GameClient.class);
    }

    public LeagueClient league() {
        return (LeagueClient)this.getClient(LeagueClient.class);
    }

    public StatsClient stats() {
        return (StatsClient)this.getClient(StatsClient.class);
    }

    public SummonerClient summoner() {
        return (SummonerClient)this.getClient(SummonerClient.class);
    }

    public TeamClient team() {
        return (TeamClient)this.getClient(TeamClient.class);
    }
}

