/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.riot.summoner;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import net.joelinn.riot.AbstractClient;
import net.joelinn.riot.Region;
import net.joelinn.riot.summoner.dto.MasteryPages;
import net.joelinn.riot.summoner.dto.RunePages;
import net.joelinn.riot.summoner.dto.Summoner;
import net.joelinn.riot.summoner.dto.SummonerNameList;

public class SummonerClient
extends AbstractClient {
    public SummonerClient(String apiKey, Region region) {
        super(apiKey, region);
    }

    @Override
    protected String getVersion() {
        return "1.2";
    }

    public MasteryPages getMasteries(long summonerId) {
        return (MasteryPages)this.get(String.format("%s/masteries", summonerId)).getEntity(MasteryPages.class);
    }

    public RunePages getRunes(long summonerId) {
        return (RunePages)this.get(String.format("%s/runes", summonerId)).getEntity(RunePages.class);
    }

    public Summoner getSummoner(String name) {
        return (Summoner)this.get(String.format("by-name/%s", name)).getEntity(Summoner.class);
    }

    public Summoner getSummoner(long summonerId) {
        return (Summoner)this.get(Long.toString(summonerId)).getEntity(Summoner.class);
    }

    public SummonerNameList getSummonerNames(long ... summonerIds) {
        String joined = "";
        String comma = "";
        for (long id : summonerIds) {
            joined = joined + comma + Long.toString(id);
            comma = ",";
        }
        return (SummonerNameList)this.get(String.format("%s/name", joined)).getEntity(SummonerNameList.class);
    }

    @Override
    protected ClientResponse request(String method, String url, MultivaluedMapImpl queryParams, MultivaluedMapImpl data) {
        return super.request(method, "summoner/" + url, queryParams, data);
    }
}

