/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.asana.tasks;

import com.google.common.primitives.Longs;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.joelinn.asana.AbstractRequestBuilder;

public class TaskRequestBuilder
extends AbstractRequestBuilder {
    public static final String ASSIGNEE_STATUS_INBOX = "inbox";
    public static final String ASSIGNEE_STATUS_LATER = "later";
    public static final String ASSIGNEE_STATUS_TODAY = "today";
    public static final String ASSIGNEE_STATUS_UPCOMING = "upcoming";
    protected String[] validAssigneeStatuses = new String[]{"inbox", "later", "today", "upcoming"};
    protected List<Long> followers = new ArrayList<Long>();
    protected List<Long> projects = new ArrayList<Long>();

    public TaskRequestBuilder() {
    }

    public TaskRequestBuilder(long workspace, String name) {
        this.workspace(workspace).name(name);
    }

    public TaskRequestBuilder assignee(long assignee) {
        return (TaskRequestBuilder)this.setParam("assignee", assignee);
    }

    public TaskRequestBuilder name(String name) {
        return (TaskRequestBuilder)this.setParam("name", name);
    }

    public TaskRequestBuilder workspace(long workspace) {
        return (TaskRequestBuilder)this.setParam("workspace", workspace);
    }

    public TaskRequestBuilder notes(String notes) {
        return (TaskRequestBuilder)this.setParam("notes", notes);
    }

    public TaskRequestBuilder addFollower(long follower) {
        this.followers.add(follower);
        return this;
    }

    public TaskRequestBuilder followers(long[] followers) {
        this.followers = Longs.asList(followers);
        return this;
    }

    public TaskRequestBuilder parent(long parentId) {
        return (TaskRequestBuilder)this.setParam("parent", parentId);
    }

    public TaskRequestBuilder addProject(long projectId) {
        this.projects.add(projectId);
        return this;
    }

    public TaskRequestBuilder setProjects(long[] projects) {
        this.projects = Longs.asList(projects);
        return this;
    }

    public TaskRequestBuilder assigneeStatus(String status) {
        if (!Arrays.asList(this.validAssigneeStatuses).contains(status)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid task status value.", status));
        }
        return (TaskRequestBuilder)this.setParam("status", status);
    }

    public TaskRequestBuilder completed(boolean completed) {
        return (TaskRequestBuilder)this.setParam("completed", completed);
    }

    public TaskRequestBuilder dueOn(String date) {
        return (TaskRequestBuilder)this.setParam("due_on", date);
    }

    public TaskRequestBuilder dueOn(int year, int month, int day) {
        return this.dueOn(String.format("%04d-%02d-%02d", year, month, day));
    }

    @Override
    public MultivaluedMapImpl build() {
        int i;
        if (this.followers.size() > 0) {
            for (i = 0; i < this.followers.size(); ++i) {
                this.params.add(String.format("followers[%s]", i), (Object)this.followers.get(i));
            }
        }
        if (this.projects.size() > 0) {
            for (i = 0; i < this.projects.size(); ++i) {
                this.params.add(String.format("projects[%s]", i), (Object)this.projects.get(i));
            }
        }
        return this.params;
    }
}

