/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.asana.workspaces;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import net.joelinn.asana.AbstractClient;
import net.joelinn.asana.Error;
import net.joelinn.asana.Errors;
import net.joelinn.asana.ForbiddenException;
import net.joelinn.asana.projects.Projects;
import net.joelinn.asana.tags.Tags;
import net.joelinn.asana.tasks.Tasks;
import net.joelinn.asana.users.Users;
import net.joelinn.asana.workspaces.Workspace;
import net.joelinn.asana.workspaces.Workspaces;

public class WorkspacesClient
extends AbstractClient {
    public WorkspacesClient(String apiKey) {
        super(apiKey);
    }

    public Workspaces getWorkspaces() {
        return this.get("").getEntity(Workspaces.class);
    }

    public Workspace updateWorkspace(long workspaceId, String name) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("name", name);
        ClientResponse clientResponse = this.put(Long.toString(workspaceId), params);
        if (clientResponse.getClientResponseStatus().getStatusCode() == ClientResponse.Status.FORBIDDEN.getStatusCode()) {
            throw new ForbiddenException(((Error)clientResponse.getEntity(Errors.class).get((int)0)).message);
        }
        return clientResponse.getEntity(Workspace.class);
    }

    public Users getUsers(long workspaceId) {
        return this.get(String.format("%s/users", workspaceId)).getEntity(Users.class);
    }

    public Tasks getTasks(long workspaceId, long assigneeId) {
        return this.getTasks(workspaceId, assigneeId, null);
    }

    public Tasks getTasks(long workspaceId, long assigneeId, Long projectId) {
        return this.getTasks(workspaceId, assigneeId, projectId, false);
    }

    public Tasks getTasks(long workspaceId, long assigneeId, Long projectId, boolean include_archived) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("assignee", (Object)assigneeId);
        params.add("include_archived", (Object)include_archived);
        if (projectId != null) {
            params.add("project", (Object)projectId);
        }
        return this.get(String.format("%s/tasks", workspaceId), params).getEntity(Tasks.class);
    }

    public Projects getProjects(long workspaceId) {
        return this.getProjects(workspaceId, false);
    }

    public Projects getProjects(long workspaceId, boolean archived) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("archived", (Object)archived);
        return this.get(String.format("%s/projects", workspaceId), params).getEntity(Projects.class);
    }

    public Tags getTags(long workspaceId) {
        return this.get(String.format("%s/tags", workspaceId)).getEntity(Tags.class);
    }

    @Override
    protected ClientResponse request(String method, String url, MultivaluedMapImpl queryParams, MultivaluedMapImpl data) {
        return super.request(method, "workspaces/" + url, queryParams, data);
    }
}

