/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.asana.projects;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import net.joelinn.asana.AbstractClient;
import net.joelinn.asana.projects.Project;
import net.joelinn.asana.projects.ProjectRequestBuilder;
import net.joelinn.asana.projects.Projects;
import net.joelinn.asana.tasks.Tasks;

public class ProjectsClient
extends AbstractClient {
    public ProjectsClient(String apiKey) {
        super(apiKey);
    }

    public Project createProject(ProjectRequestBuilder builder) {
        return this.post("", builder.build()).getEntity(Project.class);
    }

    public Project updateProject(long projectId, ProjectRequestBuilder builder) {
        return this.put(Long.toString(projectId), builder.build()).getEntity(Project.class);
    }

    public Project getProject(long projectId) {
        return this.get(Long.toString(projectId)).getEntity(Project.class);
    }

    public void deleteProject(long projectId) {
        this.delete(Long.toString(projectId));
    }

    public Tasks getTasks(long projectId) {
        return this.get(String.format("%s/tasks", projectId)).getEntity(Tasks.class);
    }

    public Projects getProjects(long workspaceId, boolean archived) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("workspace", (Object)workspaceId);
        params.add("archvied", (Object)archived);
        return this.get("", params).getEntity(Projects.class);
    }

    @Override
    protected ClientResponse request(String method, String url, MultivaluedMapImpl queryParams, MultivaluedMapImpl data) {
        return super.request(method, "projects/" + url, queryParams, data);
    }
}

