/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.asana.tasks;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import net.joelinn.asana.AbstractClient;
import net.joelinn.asana.projects.Projects;
import net.joelinn.asana.stories.Stories;
import net.joelinn.asana.stories.Story;
import net.joelinn.asana.tags.Tags;
import net.joelinn.asana.tasks.Task;
import net.joelinn.asana.tasks.TaskRequestBuilder;
import net.joelinn.asana.tasks.Tasks;

public class TasksClient
extends AbstractClient {
    public TasksClient(String apiKey) {
        super(apiKey);
    }

    public Task createTask(TaskRequestBuilder builder) {
        return (Task)this.post("tasks", builder.build()).getEntity(Task.class);
    }

    public Task updateTask(long taskId, TaskRequestBuilder builder) {
        return (Task)this.put(String.format("tasks/%s", taskId), builder.build()).getEntity(Task.class);
    }

    public void deleteTask(long taskId) {
        this.delete(String.format("tasks/%s", taskId));
    }

    public Task getTask(long taskId) {
        return (Task)this.get(String.format("tasks/%s", taskId)).getEntity(Task.class);
    }

    public Tasks getTasks() {
        return this.getTasks(false);
    }

    public Tasks getTasks(boolean includeArchived) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("include_archived", (Object)includeArchived);
        return (Tasks)this.get("tasks", params).getEntity(Tasks.class);
    }

    public Tasks getSubtasks(long taskId) {
        return (Tasks)this.get(String.format("tasks/%s/subtasks", taskId)).getEntity(Tasks.class);
    }

    public Stories getStories(long taskId) {
        return (Stories)this.get(String.format("tasks/%s/stories", taskId)).getEntity(Stories.class);
    }

    public Story createStory(long taskId, String text) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("text", text);
        return (Story)this.post(String.format("tasks/%s/stories", taskId), params).getEntity(Story.class);
    }

    public Projects getProjects(long taskId) {
        return (Projects)this.get(String.format("tasks/%s/projects", taskId)).getEntity(Projects.class);
    }

    public void addProject(long taskId, long projectId, long insertId, boolean insertBefore) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (insertBefore) {
            params.add("insert_before", (Object)insertId);
        } else {
            params.add("insert_after", (Object)insertId);
        }
        params.add("project", (Object)projectId);
        this.post(String.format("tasks/%s/addProject", taskId), params);
    }

    public void addProject(long taskId, long projectId) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("project", (Object)projectId);
        this.post(String.format("tasks/%s/addProject", taskId), params);
    }

    public void removeProject(long taskId, long projectId) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("project", (Object)projectId);
        this.post(String.format("tasks/%s/removeProject", taskId), params);
    }

    public Tags getTags(long taskId) {
        return (Tags)this.get(String.format("tasks/%s/tags", taskId)).getEntity(Tags.class);
    }

    public void addTag(long taskId, long tagId) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("tag", (Object)tagId);
        this.post(String.format("tasks/%s/addTag", taskId), params);
    }

    public void removeTag(long taskId, long tagId) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("tag", (Object)tagId);
        this.post(String.format("tasks/%s/removeTag", taskId), params);
    }
}

