/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.asana;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.joelinn.asana.AbstractClient;
import net.joelinn.asana.projects.ProjectsClient;
import net.joelinn.asana.stories.StoriesClient;
import net.joelinn.asana.tags.TagsClient;
import net.joelinn.asana.tasks.TasksClient;
import net.joelinn.asana.teams.TeamsClient;
import net.joelinn.asana.users.UsersClient;
import net.joelinn.asana.workspaces.WorkspacesClient;

public class Asana {
    protected String apiKey;
    private Integer connectionTimeout;
    private Integer readTimeout;
    protected Map<Class<? extends AbstractClient>, AbstractClient> clients;

    public Asana(String apiKey) {
        this.apiKey = apiKey;
        this.clients = new HashMap<Class<? extends AbstractClient>, AbstractClient>();
    }

    public Asana(String apiKey, int connectionTimeout, int readTimeout) {
        this(apiKey);
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    protected <T> T getClient(Class<? extends AbstractClient> clazz) {
        if (!this.clients.containsKey(clazz)) {
            try {
                AbstractClient client = this.connectionTimeout != null && this.readTimeout != null ? clazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE).newInstance(this.apiKey, this.connectionTimeout, this.readTimeout) : clazz.getConstructor(String.class).newInstance(this.apiKey);
                this.clients.put(clazz, client);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return (T)this.clients.get(clazz);
    }

    public ProjectsClient projects() {
        return (ProjectsClient)this.getClient(ProjectsClient.class);
    }

    public StoriesClient stories() {
        return (StoriesClient)this.getClient(StoriesClient.class);
    }

    public TagsClient tags() {
        return (TagsClient)this.getClient(TagsClient.class);
    }

    public TasksClient tasks() {
        return (TasksClient)this.getClient(TasksClient.class);
    }

    public TeamsClient teams() {
        return (TeamsClient)this.getClient(TeamsClient.class);
    }

    public UsersClient users() {
        return (UsersClient)this.getClient(UsersClient.class);
    }

    public WorkspacesClient workspaces() {
        return (WorkspacesClient)this.getClient(WorkspacesClient.class);
    }
}

