/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.asana;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.UriBuilder;
import net.joelinn.asana.ApiException;
import net.joelinn.asana.Error;
import net.joelinn.asana.Errors;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AbstractClient {
    public static final String BASE_URL = "https://app.asana.com/api/1.0/";
    protected String apiKey;
    protected WebResource service;

    public AbstractClient(String apiKey) {
        this(apiKey, 0, 0);
    }

    public AbstractClient(String apiKey, int connectionTimeout, int readTimeout) {
        this.apiKey = apiKey;
        DefaultClientConfig config = new DefaultClientConfig();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.UNWRAP_ROOT_VALUE, true);
        JacksonJsonProvider provider = new JacksonJsonProvider(mapper);
        config.getSingletons().add(provider);
        Client client = Client.create(config);
        client.addFilter(new HTTPBasicAuthFilter(apiKey, ""));
        client.setConnectTimeout(connectionTimeout);
        client.setReadTimeout(readTimeout);
        this.service = client.resource(UriBuilder.fromUri(BASE_URL).build(new Object[0]));
    }

    protected ClientResponse get(String url) {
        return this.get(url, null);
    }

    protected ClientResponse get(String url, MultivaluedMapImpl queryParams) {
        return this.request("GET", url, queryParams);
    }

    protected ClientResponse post(String url, MultivaluedMapImpl data) {
        return this.request("POST", url, null, data);
    }

    protected ClientResponse put(String url, MultivaluedMapImpl data) {
        return this.request("PUT", url, null, data);
    }

    protected ClientResponse delete(String url) {
        return this.request("DELETE", url);
    }

    protected ClientResponse request(String method, String url) {
        return this.request(method, url, null);
    }

    protected ClientResponse request(String method, String url, MultivaluedMapImpl queryParams) {
        return this.request(method, url, queryParams, null);
    }

    protected ClientResponse request(String method, String url, MultivaluedMapImpl queryParams, MultivaluedMapImpl data) {
        ClientResponse clientResponse = this.getResourceBuilder(url, queryParams).method(method, ClientResponse.class, (Object)data);
        this.checkForErrors(clientResponse);
        return clientResponse;
    }

    private void checkForErrors(ClientResponse clientResponse) {
        if (clientResponse.getClientResponseStatus().getStatusCode() != ClientResponse.Status.OK.getStatusCode() && clientResponse.getClientResponseStatus().getStatusCode() != ClientResponse.Status.CREATED.getStatusCode()) {
            throw new ApiException(clientResponse.getClientResponseStatus(), ((Error)clientResponse.getEntity(Errors.class).get((int)0)).message);
        }
    }

    private WebResource.Builder getResourceBuilder(String url, MultivaluedMapImpl queryParams) {
        WebResource webResource = this.service.path(url);
        if (queryParams != null) {
            webResource = webResource.queryParams(queryParams);
        }
        return (WebResource.Builder)webResource.accept("application/json").type("application/x-www-form-urlencoded");
    }
}

