/*
 * Decompiled with CFR 0.152.
 */
package net.jmob.jsconf.core.service;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import net.jmob.jsconf.core.ConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchResource {
    private static final String[] CONFIG_EXTENSIONS = new String[]{"", ".json", ".conf"};
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConfigurationFactory configurationFactory;
    private Thread thread;

    public WatchResource(ConfigurationFactory configurationFactory) {
        this.configurationFactory = configurationFactory;
    }

    public WatchResource watch(String resource) {
        Path path = this.getConfigurationPath(resource);
        if (path != null) {
            this.thread = new Thread((Runnable)new WatchTask(this.configurationFactory, path), "Configuration watching Service");
            this.thread.start();
        }
        return this;
    }

    public void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    private Path getConfigurationPath(String resource) {
        URL systemResource = null;
        for (String extension : CONFIG_EXTENSIONS) {
            if (systemResource != null) continue;
            systemResource = ClassLoader.getSystemResource(resource.concat(extension));
        }
        if (systemResource == null) {
            return null;
        }
        try {
            return Paths.get(systemResource.toURI()).getParent();
        }
        catch (URISyntaxException e) {
            this.log.error("Unable to get the path of resource", (Throwable)e);
            return null;
        }
    }

    private static final class WatchTask
    implements Runnable {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final ConfigurationFactory configuration;
        private final Path path;

        private WatchTask(ConfigurationFactory configuration, Path path) {
            this.configuration = configuration;
            this.path = path;
        }

        @Override
        public void run() {
            try (WatchService watchService = this.path.getFileSystem().newWatchService();){
                WatchKey watchKey;
                this.path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                this.log.debug("Watch configuration change on {}", (Object)this.path);
                do {
                    watchKey = watchService.take();
                    for (WatchEvent<?> event : watchKey.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (!StandardWatchEventKinds.ENTRY_CREATE.equals(kind) && !StandardWatchEventKinds.ENTRY_MODIFY.equals(kind)) continue;
                        this.log.debug("Reloading configuration");
                        this.configuration.reload();
                        return;
                    }
                } while (watchKey.reset());
                this.log.info("Configuration watching service stopped");
                watchKey.cancel();
            }
            catch (IOException e) {
                this.log.error("Configuration watching service stopped", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.log.error("Configuration watching service stopped", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

