/*
 * Decompiled with CFR 0.152.
 */
package net.jmob.jsconf.core.service;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;

public class ClassPathScanningCandidate
extends ClassPathScanningCandidateComponentProvider {
    public ClassPathScanningCandidate(boolean useDefaultFilters) {
        super(useDefaultFilters);
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return true;
    }

    public Set<Class<?>> findCandidateClass(String forPackage) {
        LinkedHashSet candidates = new LinkedHashSet();
        Set candidateComponents = super.findCandidateComponents(forPackage);
        for (BeanDefinition cl : candidateComponents) {
            try {
                candidates.add(Thread.currentThread().getContextClassLoader().loadClass(cl.getBeanClassName()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return candidates;
    }
}

