/*
 * Decompiled with CFR 0.152.
 */
package net.jmob.jsconf.core.impl;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public class ProxyPostProcessor {
    private final Map<String, BeanProxy> proxyRef = new HashMap<String, BeanProxy>();
    private final ApplicationContext context;

    public ProxyPostProcessor(ApplicationContext context) {
        this.context = context;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean.getClass().getInterfaces().length > 0) {
            BeanProxy proxy = this.proxyRef.computeIfAbsent(beanName, key -> {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                ArrayList asList = new ArrayList(Arrays.asList(bean.getClass().getInterfaces()));
                asList.add(BeanProxy.class);
                Class[] interfaces = asList.toArray(new Class[asList.size()]);
                return (BeanProxy)Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)new ProxyHandler());
            });
            proxy.setBean(bean);
            return proxy;
        }
        throw new BeanCreationException(beanName, String.format("Reloading is only available on bean with interfaces : %s", beanName));
    }

    public void forceProxyInitialization() {
        for (String beanName : this.proxyRef.keySet()) {
            this.context.getBean(beanName);
        }
    }

    private static class ProxyHandler
    implements InvocationHandler {
        private Object bean;

        private ProxyHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.isAnnotationPresent(SetBeanMethod.class)) {
                this.bean = args[0];
                return null;
            }
            return method.invoke(this.bean, args);
        }
    }

    private static interface BeanProxy {
        @SetBeanMethod
        public void setBean(Object var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface SetBeanMethod {
    }
}

