/*
 * Decompiled with CFR 0.152.
 */
package net.jmob.jsconf.core.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jmob.jsconf.core.impl.BeanDefinition;
import net.jmob.jsconf.core.impl.VirtualBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;

public class BeanFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ApplicationContext context;
    private BeanDefinition beanDefinition;
    private Config config;
    private String path;
    private Map<String, BeanDefinition> beanDefinitions;

    public BeanFactory(ApplicationContext context) {
        this.context = context;
    }

    public BeanFactory withBeanDefinition(BeanDefinition beanDefinition) {
        this.beanDefinition = beanDefinition;
        return this;
    }

    public BeanFactory withBeanDefinitions(Map<String, BeanDefinition> beanDefinitions) {
        this.beanDefinitions = beanDefinitions;
        return this;
    }

    public BeanFactory withPath(String path) {
        this.path = path;
        return this;
    }

    public BeanFactory withConfig(Config config) {
        this.config = config;
        return this;
    }

    public boolean isReloading() {
        return this.beanDefinition.isReloading();
    }

    public String registerBean() {
        String beanId = this.beanDefinition.getId();
        this.log.debug("Initialize bean id : {}", (Object)beanId);
        BeanDefinitionBuilder bd = this.beanDefinition.isAInterface() ? this.buildBeanFromInterface() : this.buildBeanFromClass();
        this.log.debug("Register bean id : {}", (Object)beanId);
        AutowireCapableBeanFactory factory = this.context.getAutowireCapableBeanFactory();
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)factory;
        registry.registerBeanDefinition(beanId, (org.springframework.beans.factory.config.BeanDefinition)bd.getBeanDefinition());
        return beanId;
    }

    private BeanDefinitionBuilder buildBeanFromClass() {
        try {
            BeanDefinitionBuilder bd = BeanDefinitionBuilder.genericBeanDefinition(Class.forName(this.beanDefinition.getClassName()));
            return this.addPropertiesValue(bd, this.buildProperties(bd));
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException(String.format("Class not found : %s", this.beanDefinition.getClassName()), (Throwable)e);
        }
    }

    private BeanDefinitionBuilder buildBeanFromInterface() {
        try {
            Class<?> classBean = Class.forName(this.beanDefinition.getClassName());
            if (!classBean.isInterface()) {
                throw new BeanCreationException(String.format("Interface is not an interface : %s", this.beanDefinition.getClassName()));
            }
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(VirtualBean.class);
            return beanDefinitionBuilder.setFactoryMethod("factory").addConstructorArgValue(classBean).addConstructorArgValue(this.unwrapProperties(this.buildProperties(beanDefinitionBuilder)));
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException(String.format("Class not found : %s", this.beanDefinition.getClassName()), (Throwable)e);
        }
    }

    private Map<String, Object> unwrapProperties(Set<Map.Entry<String, ConfigValue>> properties) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (properties != null) {
            for (Map.Entry<String, ConfigValue> e : properties) {
                values.put(e.getKey(), e.getValue().unwrapped());
            }
        }
        return values;
    }

    private BeanDefinitionBuilder addPropertiesValue(BeanDefinitionBuilder beanDefinition, Set<Map.Entry<String, ConfigValue>> properties) {
        for (Map.Entry<String, ConfigValue> e : properties) {
            beanDefinition.addPropertyValue(e.getKey(), e.getValue().unwrapped());
        }
        return beanDefinition;
    }

    private Set<Map.Entry<String, ConfigValue>> buildProperties(BeanDefinitionBuilder beanDefinition) {
        Set<String> paths = this.beanDefinitions.keySet();
        HashSet<Map.Entry<String, ConfigValue>> entries = new HashSet<Map.Entry<String, ConfigValue>>();
        try {
            for (Map.Entry entry : this.config.getConfig(this.path).root().entrySet()) {
                String fullPath = this.path.concat(".").concat((String)entry.getKey());
                if (paths.contains(fullPath)) {
                    beanDefinition.addPropertyReference((String)entry.getKey(), this.beanDefinitions.get(fullPath).getId());
                    continue;
                }
                entries.add(entry);
            }
        }
        catch (ConfigException.Missing e) {
            this.log.debug(String.format("No configuration found on path %s", this.path));
        }
        return entries;
    }
}

