/*
 * Decompiled with CFR 0.152.
 */
package net.jmob.jsconf.core.impl;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;

class BeanValidator {
    private static final Logger log = LoggerFactory.getLogger(BeanValidator.class);
    private static final ValidatorFactory factory;

    BeanValidator() {
    }

    public static <T> void beanValidation(T bean, Class<T> beanInterface) throws BeanCreationException {
        Set constraintsViolation;
        if (factory != null && !(constraintsViolation = factory.getValidator().validate(bean, new Class[0])).isEmpty()) {
            throw new BeanCreationException(String.format("Constraint violation on %s : %s", beanInterface, ((ConstraintViolation)constraintsViolation.iterator().next()).getMessage()));
        }
    }

    static {
        ValidatorFactory f = null;
        try {
            f = Validation.buildDefaultValidatorFactory();
            log.debug("Vadliation factory builded");
        }
        catch (ValidationException e) {
            log.debug("No vadliation factory found in classpath");
        }
        finally {
            factory = f;
        }
    }
}

