/*
 * Decompiled with CFR 0.152.
 */
package net.jmob.jsconf.core;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jmob.jsconf.core.ConfigFormat;
import net.jmob.jsconf.core.ConfigurationProperties;
import net.jmob.jsconf.core.impl.BeanDefinition;
import net.jmob.jsconf.core.impl.BeanFactory;
import net.jmob.jsconf.core.impl.ProxyPostProcessor;
import net.jmob.jsconf.core.service.ClassPathScanningCandidate;
import net.jmob.jsconf.core.service.WatchResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ConfigurationFactory
implements ApplicationContextAware,
BeanFactoryPostProcessor,
BeanPostProcessor {
    private static final String PROFILE_SEPARATOR = "-";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> beanName = new HashSet<String>();
    private final Set<String> proxyBeanName = new HashSet<String>();
    private final List<WatchResource> watcher = new ArrayList<WatchResource>();
    private final Config config = ConfigFactory.empty();
    private final Map<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();
    private String resourceName;
    private boolean withProfiles = false;
    private GenericApplicationContext context;
    private ProxyPostProcessor proxyPostProcessor;
    private ConfigParseOptions options = ConfigParseOptions.defaults().setAllowMissing(false);

    public void setFormat(ConfigFormat format) {
        if (format != null) {
            this.options = this.options.setSyntax(ConfigSyntax.valueOf((String)format.name()));
        }
    }

    public void setStrict(boolean strict) {
        this.options = this.options.setAllowMissing(!strict);
    }

    public void setProfiles(boolean withProfiles) {
        this.withProfiles = withProfiles;
    }

    public ConfigurationFactory withFormat(ConfigFormat format) {
        this.setFormat(format);
        return this;
    }

    public ConfigurationFactory strict() {
        return this.withStrict(true);
    }

    public ConfigurationFactory withStrict(boolean strict) {
        this.setStrict(strict);
        return this;
    }

    public ConfigurationFactory useProfiles() {
        return this.withProfiles(true);
    }

    public ConfigurationFactory withProfiles(boolean profile) {
        this.setProfiles(profile);
        return this;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ConfigurationFactory withResourceName(String resourceName) {
        this.setResourceName(resourceName);
        return this;
    }

    public ConfigurationFactory withScanPackage(String forPackage) {
        ClassPathScanningCandidate candidateComponentProvider = new ClassPathScanningCandidate(false);
        candidateComponentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ConfigurationProperties.class));
        Set<Class<?>> candidate = candidateComponentProvider.findCandidateClass(forPackage);
        for (Class<?> cl : candidate) {
            this.withBean(cl);
        }
        return this;
    }

    public ConfigurationFactory withBean(Class<?> bean) {
        if (bean.isAnnotationPresent(ConfigurationProperties.class)) {
            ConfigurationProperties cf = bean.getAnnotation(ConfigurationProperties.class);
            return this.withBean(cf.value(), bean, cf.id(), cf.hotReloading());
        }
        throw new BeanInitializationException(String.format("Missing @ConfigurationProperties annotation on class %s", bean));
    }

    public ConfigurationFactory withBean(String path, Class<?> bean) {
        return this.withBean(path, bean, null);
    }

    public ConfigurationFactory withBean(String path, Class<?> bean, String id) {
        return this.withBean(path, bean, id, false);
    }

    public ConfigurationFactory withBean(String path, Class<?> bean, boolean reloading) {
        return this.withBean(path, bean, null, reloading);
    }

    public ConfigurationFactory withBean(String path, Class<?> bean, String id, boolean reloading) {
        this.beanDefinitions.put(path.replace('/', '.'), new BeanDefinition().withId(id).withKey(path).withReloading(reloading).withClassName(bean.getCanonicalName()).isAInterface(bean.isInterface()));
        return this;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.loadContext();
    }

    public synchronized void reload() {
        this.clearContext();
        this.loadContext();
        this.proxyPostProcessor.forceProxyInitialization();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.proxyBeanName.contains(beanName)) {
            return this.proxyPostProcessor.postProcessBeforeInitialization(bean, beanName);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (GenericApplicationContext)applicationContext;
        this.proxyPostProcessor = new ProxyPostProcessor(applicationContext);
    }

    private void loadContext() {
        this.log.debug("Loading configuration");
        Config localConfig = this.config;
        ArrayList<String> resources = new ArrayList<String>(this.withProfile(this.resourceName));
        for (String resource : resources) {
            localConfig = localConfig.withFallback((ConfigMergeable)ConfigFactory.parseResourcesAnySyntax((String)resource, (ConfigParseOptions)this.options));
        }
        this.log.debug("Initialize beans");
        this.registerBeans(localConfig);
        this.log.debug("Beans are initialized");
        if (!this.proxyBeanName.isEmpty()) {
            for (String resource : resources) {
                this.watcher.add(new WatchResource(this).watch(resource));
            }
        }
    }

    private void registerBeans(Config config) {
        for (Map.Entry<String, BeanDefinition> entry : this.beanDefinitions.entrySet()) {
            this.registerBean(new BeanFactory(this.context).withConfig(config).withBeanDefinitions(this.beanDefinitions).withPath(entry.getKey()).withBeanDefinition(entry.getValue()));
        }
    }

    private void clearContext() {
        for (WatchResource watch : this.watcher) {
            watch.stop();
        }
        for (String name : this.beanName) {
            this.context.removeBeanDefinition(name);
        }
        this.watcher.clear();
        this.beanName.clear();
        this.proxyBeanName.clear();
    }

    private String registerBean(BeanFactory beanBuilder) {
        String beanId = beanBuilder.registerBean();
        if (beanBuilder.isReloading()) {
            this.proxyBeanName.add(beanId);
        }
        this.beanName.add(beanId);
        return beanId;
    }

    private List<String> withProfile(String name) {
        ArrayList<String> resourcesName = new ArrayList<String>();
        if (this.withProfiles) {
            String[] profiles;
            for (String profile : profiles = this.context.getEnvironment().getActiveProfiles()) {
                resourcesName.add(this.buildNameWithProfile(name, profile));
            }
        }
        resourcesName.add(name);
        return resourcesName;
    }

    private String buildNameWithProfile(String name, String profile) {
        String nameWithProfile = name;
        int idx = name.lastIndexOf(".");
        nameWithProfile = idx > 0 ? nameWithProfile.subSequence(0, idx) + PROFILE_SEPARATOR + profile + name.substring(idx) : nameWithProfile + PROFILE_SEPARATOR + profile;
        return nameWithProfile;
    }
}

