/*
 * Decompiled with CFR 0.152.
 */
package org.jsconf.core.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jsconf.core.impl.BeanValidator;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.jmx.access.InvocationFailureException;

public class VirtualBean
implements InvocationHandler {
    private static final String GET_PREFIX = "get";
    private static final String HASH_CODE_METHOD = "hashCode";
    private static final String EQUALS_METHOD = "equals";
    private static final String TO_STRING_METHOD = "toString";
    private final Map<String, Object> values = new HashMap<String, Object>();

    public VirtualBean(Map<String, Object> values) {
        for (Map.Entry<String, Object> e : values == null ? this.values.entrySet() : values.entrySet()) {
            this.values.put(this.toGetMethod(e.getKey()), e.getValue());
        }
    }

    public static <T> T factory(Class<T> beanInterface, Map<String, Object> values) throws BeanCreationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ArrayList<Class<T>> asList = new ArrayList<Class<T>>();
        asList.add(beanInterface);
        Class[] interfaces = asList.toArray(new Class[asList.size()]);
        Object bean = Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)new VirtualBean(values));
        BeanValidator.beanValidation(bean, beanInterface);
        return (T)bean;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int nbArgs = this.nbArgs(args);
        if (methodName.startsWith(GET_PREFIX) && nbArgs == 0) {
            return this.magicGet(methodName);
        }
        if (methodName.startsWith(HASH_CODE_METHOD) && nbArgs == 0) {
            return this.hashCode();
        }
        if (methodName.startsWith(TO_STRING_METHOD) && nbArgs == 0) {
            return this.toString();
        }
        if (methodName.startsWith(EQUALS_METHOD) && nbArgs == 1) {
            return this.equals(args[0]);
        }
        throw new InvocationFailureException(String.format("Incorrect method name %s:%s", methodName, nbArgs));
    }

    private Object magicGet(String methodName) {
        return this.values.get(methodName);
    }

    private int nbArgs(Object[] args) {
        return args == null ? 0 : args.length;
    }

    private String toGetMethod(String propertyName) {
        if (propertyName.length() <= 1) {
            return GET_PREFIX + propertyName.toUpperCase();
        }
        return GET_PREFIX + propertyName.substring(0, 1).toUpperCase().concat(propertyName.substring(1));
    }

    public String toString() {
        return this.values.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (Proxy.isProxyClass(obj.getClass())) {
            return obj.equals(this);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualBean other = (VirtualBean)obj;
        return this.values.equals(other.values);
    }

    public int hashCode() {
        int prime = 47;
        return 47 + this.values.hashCode();
    }
}

