/*
 * Decompiled with CFR 0.152.
 */
package org.jsconf.core.impl;

import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jsconf.core.ConfigurationFactory;
import org.jsconf.core.impl.VirtualBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.StringUtils;

public class BeanFactory {
    public static final String ID = "@Id";
    public static final String CLASS = "@Class";
    public static final String INTERFACE = "@Interface";
    public static final String PARENT = "@Parent";
    public static final String REF = "@Ref";
    public static final String PROXY = "@Proxy";
    private static final String[] RESERVED_WORD = new String[]{"@Id", "@Class", "@Interface", "@Parent", "@Ref", "@Proxy"};
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConfigurationFactory confFactory;
    private final GenericApplicationContext context;
    private String key;
    private String id;
    private String className;
    private String interfaceName;
    private String parentId;
    private String childName;
    private boolean proxy;
    private boolean isValid;
    private Map<String, ConfigValue> properties;

    public BeanFactory(ConfigurationFactory confFactory, GenericApplicationContext context) {
        this.confFactory = confFactory;
        this.context = context;
    }

    public BeanFactory withConfig(Map.Entry<String, ConfigValue> config) {
        if (!this.isABeanConfigEntry(config)) {
            return this;
        }
        this.isValid = true;
        this.key = config.getKey();
        this.id = (String)this.getBeanValue(config, ID);
        this.className = (String)this.getBeanValue(config, CLASS);
        this.interfaceName = (String)this.getBeanValue(config, INTERFACE);
        this.parentId = (String)this.getBeanValue(config, PARENT);
        this.proxy = Boolean.TRUE.equals(this.getBeanValue(config, PROXY));
        if (this.isAMap(config.getValue())) {
            this.properties = (Map)config.getValue();
        }
        return this;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public String registerBean() {
        BeanDefinitionBuilder beanDefinition;
        String beanId = this.id;
        if (StringUtils.isEmpty((Object)beanId)) {
            beanId = StringUtils.hasText((String)this.childName) ? this.childName : this.key;
        }
        this.log.debug("Initalize bean id : {}", (Object)beanId);
        if (StringUtils.hasText((String)this.parentId)) {
            beanDefinition = this.buildBEanFromParent(beanId);
        } else if (StringUtils.hasText((String)this.className)) {
            beanDefinition = this.buildBeanFromClass(beanId);
        } else if (StringUtils.hasText((String)this.interfaceName)) {
            beanDefinition = this.buildBeanFromInterface();
        } else {
            throw new BeanCreationException(beanId, "Bean have not class or parent defined");
        }
        this.log.debug("Regitre bean id : {}", (Object)beanId);
        this.context.registerBeanDefinition(beanId, (BeanDefinition)beanDefinition.getBeanDefinition());
        return beanId;
    }

    private BeanDefinitionBuilder buildBEanFromParent(String beanId) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.childBeanDefinition((String)this.parentId);
        if (StringUtils.hasText((String)this.className)) {
            throw new BeanCreationException(beanId, String.format("Bean have a Class %s and a Parent defined : %s", this.className, this.parentId));
        }
        return this.setBeanProperties(beanDefinition, beanId, this.properties);
    }

    private BeanDefinitionBuilder buildBeanFromClass(String beanId) {
        try {
            BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(Class.forName(this.className));
            return this.setBeanProperties(beanDefinition, beanId, this.properties);
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException(String.format("Class not found : %s", this.className), (Throwable)e);
        }
    }

    private BeanDefinitionBuilder buildBeanFromInterface() {
        try {
            Class<?> classBean = Class.forName(this.interfaceName);
            if (!classBean.isInterface()) {
                throw new BeanCreationException(String.format("Interface is not an interface : %s", this.interfaceName));
            }
            return BeanDefinitionBuilder.genericBeanDefinition(VirtualBean.class).setFactoryMethod("factory").addConstructorArgValue(classBean).addConstructorArgValue(this.getAllProperties(this.properties));
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException(String.format("Class not found : %s", this.interfaceName), (Throwable)e);
        }
    }

    private BeanDefinitionBuilder setBeanProperties(BeanDefinitionBuilder beanDefinition, String beanId, Map<String, ConfigValue> properties) {
        if (properties != null) {
            int childId = 0;
            for (Map.Entry<String, ConfigValue> e : properties.entrySet()) {
                ConfigValueType valueType = e.getValue().valueType();
                if (valueType.equals((Object)ConfigValueType.OBJECT)) {
                    if (this.isABeanConfigEntry(e)) {
                        BeanFactory beanBuilder = new BeanFactory(this.confFactory, this.context);
                        beanBuilder.withConfig(e).defineChildName(beanId, ++childId);
                        beanDefinition.addPropertyReference(e.getKey(), beanBuilder.registerBean());
                        continue;
                    }
                    if (REF.equals(e.getKey())) {
                        Map refs = (Map)e.getValue().unwrapped();
                        for (Map.Entry r : refs.entrySet()) {
                            beanDefinition.addPropertyReference((String)r.getKey(), (String)r.getValue());
                        }
                        continue;
                    }
                    beanDefinition.addPropertyValue(e.getKey(), e.getValue().unwrapped());
                    continue;
                }
                if (Arrays.asList(RESERVED_WORD).contains(e.getKey())) continue;
                beanDefinition.addPropertyValue(e.getKey(), e.getValue().unwrapped());
            }
        }
        return beanDefinition;
    }

    private Map<String, Object> getAllProperties(Map<String, ConfigValue> properties) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (properties != null) {
            for (Map.Entry<String, ConfigValue> e : properties.entrySet()) {
                values.put(e.getKey(), e.getValue().unwrapped());
            }
        }
        return values;
    }

    private BeanFactory defineChildName(String parentId, int childId) {
        this.childName = parentId + "-child-" + childId;
        return this;
    }

    private <T> T getBeanValue(Map.Entry<String, ConfigValue> entry, String key) {
        ConfigValue value = entry.getValue();
        Object object = value.unwrapped();
        if (this.isAMap(object)) {
            return (T)((Map)object).get(key);
        }
        return null;
    }

    private boolean isABeanConfigEntry(Map.Entry<String, ConfigValue> entry) {
        Object object = entry.getValue().unwrapped();
        if (this.isAMap(object)) {
            Map map = (Map)object;
            return map.containsKey(CLASS) || map.containsKey(INTERFACE) || map.containsKey(PARENT);
        }
        return false;
    }

    private boolean isAMap(Object value) {
        return value instanceof Map;
    }
}

