/*
 * Decompiled with CFR 0.152.
 */
package org.jsconf.core;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsconf.core.ConfigFormat;
import org.jsconf.core.impl.BeanFactory;
import org.jsconf.core.impl.ProxyPostProcessor;
import org.jsconf.core.service.WatchResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.StringUtils;

public class ConfigurationFactory
implements ApplicationContextAware,
BeanFactoryPostProcessor,
BeanPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> beanName = new HashSet<String>();
    private final Set<String> proxyBeanName = new HashSet<String>();
    private final List<WatchResource> watcher = new ArrayList<WatchResource>();
    private boolean withDefinition = false;
    private boolean withProfiles = false;
    private String resourceName;
    private GenericApplicationContext context;
    private ProxyPostProcessor proxyPostProcessor;
    private ConfigParseOptions options = ConfigParseOptions.defaults().setAllowMissing(false);
    private Config config = ConfigFactory.empty();

    public void setFormat(ConfigFormat format) {
        if (format != null) {
            this.options = this.options.setSyntax(ConfigSyntax.valueOf((String)format.name()));
        }
    }

    public void setStrict(boolean strict) {
        this.options = this.options.setAllowMissing(!strict);
    }

    public void setDefinition(boolean withDefinition) {
        this.withDefinition = withDefinition;
    }

    public void setProfiles(boolean withProfiles) {
        this.withProfiles = withProfiles;
    }

    public ConfigurationFactory withFormat(ConfigFormat format) {
        this.setFormat(format);
        return this;
    }

    public ConfigurationFactory withStrict(boolean strict) {
        this.setStrict(strict);
        return this;
    }

    public ConfigurationFactory withDefinition(boolean def) {
        this.setDefinition(def);
        return this;
    }

    public ConfigurationFactory withProfiles(boolean profile) {
        this.setProfiles(profile);
        return this;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ConfigurationFactory withResourceName(String resourceName) {
        this.setResourceName(resourceName);
        return this;
    }

    public ConfigurationFactory withBean(String path, Class<?> bean) {
        return this.withBean(path, bean, null);
    }

    public ConfigurationFactory withBean(String path, Class<?> bean, boolean proxy) {
        return this.withBean(path, bean, null, proxy);
    }

    public ConfigurationFactory withBean(String path, Class<?> bean, String id) {
        return this.withBean(path, bean, id, false);
    }

    public ConfigurationFactory withBean(String path, Class<?> bean, String id, boolean proxy) {
        HashMap<String, Object> properties = new HashMap<String, Object>(2);
        if (StringUtils.hasText((String)id)) {
            properties.put("\"@Id\"", id);
        }
        if (proxy) {
            properties.put("\"@Proxy\"", true);
        }
        if (bean.isInterface()) {
            properties.put("\"@Interface\"", bean.getCanonicalName());
        } else {
            properties.put("\"@Class\"", bean.getCanonicalName());
        }
        String[] splitedPath = path.split("/");
        HashMap object = new HashMap(2);
        object.put(splitedPath[splitedPath.length - 1], properties);
        for (int i = splitedPath.length - 2; i >= 0; --i) {
            HashMap child = object;
            object = new HashMap(2);
            object.put(splitedPath[i], child);
        }
        this.config = this.config.withFallback((ConfigMergeable)ConfigFactory.parseMap(object));
        return this;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.loadContext();
    }

    public synchronized void reload() {
        this.clearContext();
        this.loadContext();
        this.proxyPostProcessor.forceProxyInitalization();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.proxyBeanName.contains(beanName)) {
            return this.proxyPostProcessor.postProcessBeforeInitialization(bean, beanName);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (GenericApplicationContext)applicationContext;
        this.proxyPostProcessor = new ProxyPostProcessor(applicationContext);
    }

    private void loadContext() {
        this.log.debug("Loading configuration");
        Config localConfig = this.config;
        ArrayList<String> ressources = new ArrayList<String>(this.withProfile(this.resourceName));
        for (String resource : ressources) {
            localConfig = localConfig.withFallback((ConfigMergeable)ConfigFactory.parseResourcesAnySyntax((String)resource, (ConfigParseOptions)this.options));
        }
        this.log.debug("Initalize beans");
        for (Map.Entry entry : localConfig.root().entrySet()) {
            BeanFactory beanBuilder = new BeanFactory(this, this.context).withConfig(entry);
            if (!beanBuilder.isValid()) continue;
            this.buildBeans(beanBuilder);
        }
        this.log.debug("Beans are initalzed");
        if (!this.proxyBeanName.isEmpty()) {
            for (String resource : ressources) {
                this.watcher.add(new WatchResource(this).watch(resource));
            }
        }
    }

    private void clearContext() {
        for (WatchResource watch : this.watcher) {
            watch.stop();
        }
        for (String name : this.beanName) {
            this.context.removeBeanDefinition(name);
        }
        this.watcher.clear();
        this.beanName.clear();
        this.proxyBeanName.clear();
    }

    private String buildBeans(BeanFactory beanBuilder) {
        String beanId = beanBuilder.registerBean();
        if (beanBuilder.isProxy()) {
            this.proxyBeanName.add(beanId);
        }
        this.beanName.add(beanId);
        return beanId;
    }

    private List<String> withProfile(String name) {
        ArrayList<String> ressourcesName = new ArrayList<String>();
        if (this.withProfiles) {
            String[] profiles;
            for (String profile : profiles = this.context.getEnvironment().getActiveProfiles()) {
                String nameWithProfile = name;
                int idx = name.lastIndexOf(".");
                nameWithProfile = idx > 0 ? nameWithProfile.subSequence(0, idx) + "-" + profile + name.substring(idx) : nameWithProfile + "-" + profile;
                ressourcesName.add(nameWithProfile);
            }
        }
        ressourcesName.addAll(this.withDefinition(name));
        return ressourcesName;
    }

    private List<String> withDefinition(String name) {
        ArrayList<String> ressourcesName = new ArrayList<String>();
        if (this.withDefinition) {
            int idx = name.lastIndexOf(".");
            if (idx > 0) {
                ressourcesName.add(name.subSequence(0, idx) + ".def" + name.substring(idx));
            } else {
                ressourcesName.add(name + ".def");
            }
        }
        ressourcesName.add(name);
        return ressourcesName;
    }
}

