/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import net.jlxxw.wechat.repository.ip.IpSegmentRepository;
import net.jlxxw.wechat.security.blacklist.BlackList;
import net.jlxxw.wechat.security.template.SecurityFilterTemplate;
import net.jlxxw.wechat.web.util.NetworkUtil;

public class WeChatSecurityFilter
implements Filter,
SecurityFilterTemplate {
    private final BlackList blackList;
    private final IpSegmentRepository ipSegmentRepository;

    public WeChatSecurityFilter(BlackList blackList, IpSegmentRepository ipSegmentRepository) {
        this.blackList = blackList;
        this.ipSegmentRepository = ipSegmentRepository;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void destroy() {
        super.destroy();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean http = request instanceof HttpServletRequest;
        if (!http) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String ipAddress = NetworkUtil.getIpAddress(httpServletRequest);
        boolean security = this.security(ipAddress);
        if (security) {
            chain.doFilter(request, response);
            return;
        }
        this.reject(ipAddress);
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setStatus(403);
        httpServletResponse.setContentType("text/html");
        PrintWriter writer = httpServletResponse.getWriter();
        writer.println("IP FORBIDDEN");
        writer.close();
    }

    public boolean blacklisted(String ip) {
        return this.blackList.include(ip);
    }

    public Set<String> loadAllIpSegments() {
        return this.ipSegmentRepository.findAll();
    }

    public void reject(String ip) {
        this.blackList.add(ip);
    }
}

