/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.web.controller;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.jlxxw.wechat.event.component.EventBus;
import net.jlxxw.wechat.log.util.LoggerUtils;
import net.jlxxw.wechat.properties.WeChatProperties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WeChatMessageController {
    private static final Logger logger = LoggerFactory.getLogger(WeChatMessageController.class);
    @Autowired
    private EventBus eventBus;
    @Autowired
    private WeChatProperties weChatProperties;

    @RequestMapping(value={"${wechat.event.server.web.core-controller-url:/weChat}"}, method={RequestMethod.POST, RequestMethod.GET})
    public String coreController(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String method = request.getMethod();
        if ("get".equalsIgnoreCase(method)) {
            response.setCharacterEncoding("UTF-8");
            return this.verifyToken(request);
        }
        if ("post".equalsIgnoreCase(method)) {
            try (ServletInputStream inputStream = request.getInputStream();){
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                String uri = request.getRequestURI();
                String string = request.getQueryString();
                response.setCharacterEncoding("UTF-8");
                String string2 = this.eventBus.dispatcher(bytes, uri + "?" + string);
                return string2;
            }
        }
        logger.error("\u6536\u5230\u4e86\u672a\u77e5\u8bf7\u6c42,method:{}", (Object)method);
        return "error";
    }

    private String verifyToken(HttpServletRequest request) throws NoSuchAlgorithmException {
        String msgSignature = request.getParameter("signature");
        String msgTimestamp = request.getParameter("timestamp");
        String msgNonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        LoggerUtils.info((Logger)logger, (String)"\u63a5\u6536\u5230\u5fae\u4fe1\u8bf7\u6c42\uff1asignature={},timestamp={},nonce={},echostr={}", (Object[])new Object[]{msgSignature, msgTimestamp, msgNonce, echostr});
        if (this.verify(msgSignature, msgTimestamp, msgNonce)) {
            LoggerUtils.info((Logger)logger, (String)"\u9a8c\u8bc1\u901a\u8fc7", (Object[])new Object[0]);
            return echostr;
        }
        LoggerUtils.info((Logger)logger, (String)"\u9a8c\u8bc1\u5931\u8d25", (Object[])new Object[0]);
        return "";
    }

    private boolean verify(String msgSignature, String timeStamp, String nonce) throws NoSuchAlgorithmException {
        String signature = WeChatMessageController.sha1Sign(this.weChatProperties.getVerifyToken(), timeStamp, nonce);
        if (!signature.equals(msgSignature)) {
            throw new RuntimeException("token\u8ba4\u8bc1\u5931\u8d25");
        }
        return true;
    }

    private static String sha1Sign(String token, String timestamp, String nonce) throws NoSuchAlgorithmException {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("verify-token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object[] array = new String[]{token, timestamp, nonce};
        StringBuffer sb = new StringBuffer();
        Arrays.sort(array);
        for (int i = 0; i < 3; ++i) {
            sb.append((String)array[i]);
        }
        String str = sb.toString();
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(str.getBytes());
        byte[] digest = md.digest();
        StringBuffer hexstr = new StringBuffer();
        String shaHex = "";
        for (int i = 0; i < digest.length; ++i) {
            shaHex = Integer.toHexString(digest[i] & 0xFF);
            if (shaHex.length() < 2) {
                hexstr.append(0);
            }
            hexstr.append(shaHex);
        }
        return hexstr.toString();
    }
}

