/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.http.spider.util;

import net.jlxxw.http.spider.base.AbstractRateLimiter;
import net.jlxxw.http.spider.proxy.ProxyRestTemplateObject;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.core5.http.HttpHost;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpUtils {
    private static AbstractRateLimiter abstractRateLimiter;

    public HttpUtils(@Autowired(required=false) AbstractRateLimiter abstractRateLimiter) {
        HttpUtils.abstractRateLimiter = abstractRateLimiter;
    }

    public static <T> ResponseEntity<T> exchange(ProxyRestTemplateObject object, String url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, Class<T> responseType) throws HttpHostConnectException {
        HttpHost host = object.getHost();
        if (abstractRateLimiter != null) {
            abstractRateLimiter.doLimiter(host);
        }
        RestTemplate restTemplate = object.getRestTemplate();
        return restTemplate.exchange(url, method, requestEntity, responseType, new Object[0]);
    }

    public static <T> T execute(ProxyRestTemplateObject object, String url, HttpMethod method, @Nullable RequestCallback requestCallback, @Nullable ResponseExtractor<T> responseExtractor) throws HttpHostConnectException {
        HttpHost host = object.getHost();
        if (abstractRateLimiter != null) {
            abstractRateLimiter.doLimiter(host);
        }
        RestTemplate restTemplate = object.getRestTemplate();
        return (T)restTemplate.execute(url, method, requestCallback, responseExtractor, new Object[0]);
    }
}

