/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.http.spider.proxy;

import net.jlxxw.http.spider.proxy.ProxyRestTemplateObject;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class ProxyRestTemplateFactory
extends BasePooledObjectFactory<ProxyRestTemplateObject> {
    private static final Logger logger = LoggerFactory.getLogger(ProxyRestTemplateFactory.class);
    private BeanFactory beanFactory;

    public ProxyRestTemplateFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ProxyRestTemplateObject create() throws Exception {
        return (ProxyRestTemplateObject)((Object)this.beanFactory.getBean("spiderProxyRestTemplateObject", ProxyRestTemplateObject.class));
    }

    public PooledObject<ProxyRestTemplateObject> wrap(ProxyRestTemplateObject obj) {
        return new DefaultPooledObject((Object)obj);
    }

    public boolean validateObject(PooledObject<ProxyRestTemplateObject> p) {
        ProxyRestTemplateObject object = (ProxyRestTemplateObject)((Object)p.getObject());
        boolean proxy = object.isProxy();
        boolean validate = true;
        if (proxy) {
            validate = object.validate();
        } else {
            long createTime = object.getCreateTime();
            long currentTimeMillis = System.currentTimeMillis();
            boolean bl = validate = currentTimeMillis - createTime < 300000L;
        }
        if (!validate) {
            DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)this.beanFactory;
            defaultListableBeanFactory.destroyBean((Object)object);
        }
        return validate;
    }
}

