/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.http.spider.file.thread;

import net.jlxxw.http.spider.file.FileInfo;
import net.jlxxw.http.spider.file.thread.AbstractDownloadFileThread;
import net.jlxxw.http.spider.proxy.ProxyRestTemplateObject;
import net.jlxxw.http.spider.proxy.ProxyRestTemplatePool;
import net.jlxxw.http.spider.util.HttpUtils;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;

class DownloadLittleFileThread
extends AbstractDownloadFileThread {
    private static final Logger logger = LoggerFactory.getLogger(DownloadLittleFileThread.class);
    private static final int MAX_RETRY = 3;
    private final HttpHeaders header;
    private final FileInfo fileInfo;
    private final ProxyRestTemplatePool proxyRestTemplatePool;

    public DownloadLittleFileThread(ProxyRestTemplatePool proxyRestTemplatePool, HttpHeaders header, FileInfo fileInfo) {
        this.header = header;
        this.fileInfo = fileInfo;
        this.proxyRestTemplatePool = proxyRestTemplatePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo call() {
        int i = 0;
        while (i < 3) {
            ProxyRestTemplateObject borrow = null;
            try {
                borrow = this.proxyRestTemplatePool.borrow();
                ResponseEntity<byte[]> rsp = HttpUtils.exchange(borrow, this.fileInfo.getRedirectUrl(), HttpMethod.GET, new HttpEntity((MultiValueMap)this.header), byte[].class);
                byte[] body = (byte[])rsp.getBody();
                this.fileInfo.saveLittleFile(body);
                FileInfo fileInfo = this.fileInfo;
                return fileInfo;
            }
            catch (HttpHostConnectException e) {
                if (!borrow.isProxy()) continue;
                borrow.setDelete(true);
            }
            catch (ResourceAccessException e) {
                Throwable cause = e.getCause();
                if (cause instanceof HttpHostConnectException) {
                    if (borrow == null || !borrow.isProxy()) continue;
                    borrow.setDelete(true);
                    continue;
                }
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u4ea7\u751f\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            }
            catch (HttpClientErrorException e) {
                HttpStatusCode statusCode = e.getStatusCode();
                if (statusCode.value() == 403) {
                    if (borrow == null || !borrow.isProxy()) continue;
                    borrow.setDelete(true);
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u4ea7\u751f\u672a\u77e5\u5f02\u5e38,url:" + this.fileInfo.getRedirectUrl() + ",\u6b63\u5728\u8fdb\u884c\u91cd\u8bd5,\u5f53\u524d\u6b21\u6570:" + ++i, (Throwable)e);
            }
            finally {
                if (borrow == null) continue;
                this.proxyRestTemplatePool.returnObject((Object)borrow);
            }
        }
        this.fileInfo.setFail(true);
        return this.fileInfo;
    }
}

