/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.http.spider.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfo {
    private static final Logger logger = LoggerFactory.getLogger(FileInfo.class);
    private final String cachePath;
    private final String fileName;
    private final long length;
    private byte[] data;
    private List<String> cachedFiles = new ArrayList<String>();
    private final boolean bigFile;
    private String redirectUrl;
    private boolean fail;

    public FileInfo(String fileName, long length) {
        this(fileName, length, 1);
    }

    public FileInfo(String fileName, long length, int shareSize) {
        this(fileName, length, shareSize, "./temp/" + UUID.randomUUID(), shareSize > 1);
    }

    public FileInfo(String fileName, long length, int shareSize, String cacheFilePath, boolean bigFile) {
        this.fileName = fileName;
        this.length = length;
        this.bigFile = bigFile;
        this.cachedFiles = new ArrayList<String>(shareSize);
        for (int i = 0; i < shareSize; ++i) {
            this.cachedFiles.add(null);
        }
        this.cachePath = cacheFilePath;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isBigFile() {
        return this.bigFile;
    }

    public byte[] getData() throws IOException {
        if (this.fail) {
            throw new IllegalStateException("file download failed");
        }
        if (this.bigFile) {
            for (String file : this.cachedFiles) {
                if (!StringUtils.isBlank((CharSequence)file)) continue;
                throw new IllegalStateException("file download failed");
            }
            if (this.data != null) {
                return this.data;
            }
            this.data = this.mergeReadFile(this.cachePath);
        }
        return this.data;
    }

    public void saveLittleFile(byte[] data) {
        if (this.data != null) {
            throw new IllegalStateException("\u6570\u636e\u5df2\u7ecf\u88ab\u5b58\u50a8\u4e86\uff0c\u7981\u6b62\u8986\u76d6");
        }
        this.data = data;
    }

    public void saveBigFileCache(int index, InputStream data) throws IOException {
        String path = this.cachePath + "/" + this.fileName + "." + index;
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        FileUtils.createParentDirectories((File)file);
        this.cachedFiles.set(index, path);
        Files.copy(data, Paths.get(path, new String[0]), new CopyOption[0]);
    }

    public byte[] mergeReadFile(String mergeOutPath) throws IOException {
        if (this.cachedFiles.size() == 0) {
            throw new IllegalStateException("\u5c1a\u672a\u5b58\u50a8\u6587\u4ef6");
        }
        String path = mergeOutPath + "/" + this.fileName;
        File out = new File(path);
        if (out.exists()) {
            out.delete();
        }
        FileUtils.createParentDirectories((File)out);
        out.createNewFile();
        RandomAccessFile resultFile = new RandomAccessFile(path, "rw");
        logger.info("\u5f00\u59cb\u5408\u5e76\u5206\u6bb5\u6570\u636e");
        for (String cacheFilePath : this.cachedFiles) {
            logger.info("\u5f00\u59cb\u5408\u5e76\u5206\u6bb5\u6570\u636e\u6587\u4ef6:{}", (Object)cacheFilePath);
            RandomAccessFile tempFile = new RandomAccessFile(cacheFilePath, "rw");
            tempFile.getChannel().transferTo(0L, tempFile.length(), resultFile.getChannel());
            tempFile.close();
            logger.info("\u5408\u5e76\u5206\u6bb5\u6570\u636e\u6587\u4ef6\u5b8c\u6bd5:{}", (Object)cacheFilePath);
            File file = new File(cacheFilePath);
            file.delete();
            logger.info("\u5408\u5e76\u5206\u6bb5\u6570\u636e\u6587\u4ef6\u6e05\u7406\u5b8c\u6bd5");
        }
        resultFile.close();
        byte[] bytes = FileUtils.readFileToByteArray((File)out);
        File cacheDirectory = new File(this.cachePath);
        FileUtils.deleteDirectory((File)cacheDirectory);
        return bytes;
    }

    public boolean isFail() {
        return this.fail;
    }

    public void setFail(boolean fail) {
        this.fail = fail;
    }
}

