/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.http.spider.file;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.jlxxw.http.spider.file.FileInfo;
import net.jlxxw.http.spider.file.thread.AbstractDownloadFileThread;
import net.jlxxw.http.spider.properties.FileProperties;
import net.jlxxw.http.spider.properties.HttpConcurrencyPoolProperties;
import net.jlxxw.http.spider.proxy.ProxyRestTemplatePool;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DownloadFileTools {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileTools.class);
    private int maxPoolSize;
    private final ThreadPoolTaskExecutor httpDownloadExecutor;
    private final FileProperties fileProperties;
    private final HttpConcurrencyPoolProperties httpConcurrencyPoolProperties;
    private final ProxyRestTemplatePool proxyRestTemplatePool;

    public DownloadFileTools(ThreadPoolTaskExecutor httpDownloadExecutor, BeanFactory beanFactory, FileProperties fileProperties, HttpConcurrencyPoolProperties httpConcurrencyPoolProperties, ProxyRestTemplatePool proxyRestTemplatePool) {
        this.httpDownloadExecutor = httpDownloadExecutor;
        this.fileProperties = fileProperties;
        this.maxPoolSize = httpConcurrencyPoolProperties.getMax();
        this.httpConcurrencyPoolProperties = httpConcurrencyPoolProperties;
        this.proxyRestTemplatePool = proxyRestTemplatePool;
    }

    public FileInfo download(String url, HttpHeaders httpHeader) throws Exception {
        HttpHeaders responseHeader = this.readLength(url, httpHeader);
        FileInfo info = this.createFileInfo(responseHeader);
        String redirectUrl = info.getRedirectUrl();
        if (StringUtils.isBlank((CharSequence)redirectUrl)) {
            info.setRedirectUrl(url);
        }
        long contentLength = info.getLength();
        long threadNum = this.threadNum(contentLength);
        int thread = (int)threadNum;
        boolean bigFile = info.isBigFile();
        ArrayList<Future> downLoadFileThreads = new ArrayList<Future>(thread);
        long tempLength = this.fileProperties.getShareSize();
        int index = 0;
        int totalSize = 0;
        int i = 0;
        while ((long)i < threadNum && (long)totalSize < contentLength) {
            long start = (long)i * tempLength;
            long end = start + tempLength - 1L;
            totalSize = (int)((long)totalSize + tempLength);
            AbstractDownloadFileThread downloadThread = bigFile ? AbstractDownloadFileThread.bigFileThread(this.proxyRestTemplatePool, httpHeader, info, index, start, end) : AbstractDownloadFileThread.littleFileThread(this.proxyRestTemplatePool, httpHeader, info);
            Future submit = this.httpDownloadExecutor.submit((Callable)downloadThread);
            downLoadFileThreads.add(submit);
            ++index;
            ++i;
        }
        for (Future future : downLoadFileThreads) {
            try {
                future.get(this.httpConcurrencyPoolProperties.getMaxWaitMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                for (Future fileThread : downLoadFileThreads) {
                    if (fileThread.isCancelled()) continue;
                    fileThread.cancel(true);
                }
                log.error("\u6587\u4ef6\u4e0b\u8f7d\u4ea7\u751f\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            }
        }
        return info;
    }

    private HttpHeaders readLength(String url, HttpHeaders httpHeader) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(10000L, TimeUnit.MILLISECONDS).setRedirectsEnabled(false).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)client);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpComponentsClientHttpRequestFactory);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.HEAD, new HttpEntity(null, (MultiValueMap)httpHeader), byte[].class, new Object[0]);
        HttpHeaders responseHeaders = response.getHeaders();
        URI location = responseHeaders.getLocation();
        if (Objects.nonNull(location)) {
            httpHeader.set("target-url", location.toString());
            return this.readLength(location.toString(), httpHeader);
        }
        HttpHeaders res = new HttpHeaders();
        res.putAll((Map)responseHeaders);
        res.set("target-url", url);
        return res;
    }

    private long threadNum(long length) {
        long l = length % (long)this.fileProperties.getShareSize();
        if (l == 0L) {
            return length / (long)this.fileProperties.getShareSize();
        }
        return length / (long)this.fileProperties.getShareSize() + 1L;
    }

    private boolean isBigFile(long length) {
        return length > this.fileProperties.getBigFileSize();
    }

    private FileInfo createFileInfo(HttpHeaders headers) throws UnsupportedEncodingException {
        FileInfo fileInfo;
        String fileName = "";
        String redictUrl = null;
        List list = headers.get((Object)"Content-Disposition");
        if (CollectionUtils.isEmpty((Collection)list)) {
            List targetUrls = headers.get((Object)"target-url");
            if (!CollectionUtils.isEmpty((Collection)targetUrls)) {
                redictUrl = (String)targetUrls.get(0);
            }
            String s = StringUtils.substringBeforeLast(redictUrl, (String)"?");
            fileName = StringUtils.substringAfterLast((String)s, (String)"/");
            fileName = URLDecoder.decode(fileName, String.valueOf(StandardCharsets.UTF_8));
        } else {
            String disposition = (String)list.get(0);
            fileName = disposition.replaceFirst("(?i)^.*filename=\"?([^\"]+)\"?.*$", "$1");
            fileName = URLDecoder.decode(fileName, String.valueOf(StandardCharsets.ISO_8859_1));
        }
        long contentLength = headers.getContentLength();
        boolean bigFile = this.isBigFile(contentLength);
        int share = this.share(contentLength);
        if (bigFile) {
            String cacheFilePath = this.fileProperties.getCacheFilePath();
            fileInfo = new FileInfo(fileName, contentLength, share, cacheFilePath + "/" + UUID.randomUUID(), true);
        } else {
            fileInfo = new FileInfo(fileName, contentLength);
        }
        fileInfo.setRedirectUrl(redictUrl);
        return fileInfo;
    }

    private int share(long contentLength) {
        if (contentLength % (long)this.fileProperties.getShareSize() == 0L) {
            return (int)(contentLength / (long)this.fileProperties.getShareSize());
        }
        return (int)(contentLength / (long)this.fileProperties.getShareSize()) + 1;
    }
}

