/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.http.spider.configuration;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jlxxw.http.spider.HttpSpider;
import net.jlxxw.http.spider.adapter.HttpSpiderAdapter;
import net.jlxxw.http.spider.base.AbstractCookieStore;
import net.jlxxw.http.spider.base.AbstractProxyHostProducer;
import net.jlxxw.http.spider.file.DownloadFileTools;
import net.jlxxw.http.spider.properties.FileProperties;
import net.jlxxw.http.spider.properties.HttpConcurrencyPoolProperties;
import net.jlxxw.http.spider.properties.ProxyPoolProperties;
import net.jlxxw.http.spider.properties.RestTemplateProperties;
import net.jlxxw.http.spider.proxy.ProxyRestTemplateFactory;
import net.jlxxw.http.spider.proxy.ProxyRestTemplateObject;
import net.jlxxw.http.spider.proxy.ProxyRestTemplatePool;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Scope;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.client.RestTemplate;

@ComponentScan(value={"net.jlxxw.http.spider"})
public class HttpSpiderAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(HttpSpiderAutoConfiguration.class);

    @Bean
    public ProxyRestTemplateFactory proxyRestTemplateFactory(BeanFactory beanFactory) {
        logger.info("HttpSpider ProxyRestTemplateFactory created");
        return new ProxyRestTemplateFactory(beanFactory);
    }

    @Bean
    public ProxyRestTemplatePool proxyRestTemplatePool(ProxyRestTemplateFactory proxyRestTemplateFactory, ProxyPoolProperties proxyPoolProperties) {
        logger.info("HttpSpider ProxyRestTemplatePool created");
        return new ProxyRestTemplatePool(proxyRestTemplateFactory, proxyPoolProperties);
    }

    @Bean
    @Scope(value="prototype")
    public ProxyRestTemplateObject spiderProxyRestTemplateObject(RestTemplateProperties restTemplateProperties, @Autowired(required=false) AbstractProxyHostProducer abstractProxyHostProducer, @Autowired(required=false) AbstractCookieStore abstractCookieStore) {
        HttpHost proxyHost = null;
        if (abstractProxyHostProducer != null && (proxyHost = abstractProxyHostProducer.producer()) == null) {
            logger.warn("\u672a\u80fd\u83b7\u53d6\u5230\u4ee3\u7406\u670d\u52a1\u5668\u5730\u5740");
        }
        boolean proxy = Objects.nonNull(proxyHost);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(restTemplateProperties.getMaxTotal());
        connectionManager.setDefaultMaxPerRoute(restTemplateProperties.getDefaultMaxPerRoute());
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((long)restTemplateProperties.getConnectionRequestTimeoutMillis(), TimeUnit.MILLISECONDS).setConnectTimeout((long)restTemplateProperties.getConnectTimeoutMillis(), TimeUnit.MILLISECONDS).setProxy(proxyHost).build();
        AbstractCookieStore cookieStore = Objects.isNull(abstractCookieStore) ? new BasicCookieStore() : abstractCookieStore;
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultCookieStore((CookieStore)cookieStore).build();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)client));
        logger.info("created ProxyRestTemplateObject ,proxy model:{}", (Object)proxy);
        return new ProxyRestTemplateObject(restTemplate, abstractProxyHostProducer, proxyHost);
    }

    @Bean
    public ThreadPoolTaskExecutor httpConcurrencyDownloadExecutor(HttpConcurrencyPoolProperties httpConcurrencyPoolProperties) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(httpConcurrencyPoolProperties.getMin());
        executor.setMaxPoolSize(httpConcurrencyPoolProperties.getMax());
        executor.setQueueCapacity(httpConcurrencyPoolProperties.getQueueCapacity());
        executor.setKeepAliveSeconds(1000);
        executor.setThreadNamePrefix("http-concurrency-pool-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Bean
    public DownloadFileTools downloadFileTools(ThreadPoolTaskExecutor httpConcurrencyDownloadExecutor, BeanFactory beanFactory, FileProperties fileProperties, HttpConcurrencyPoolProperties httpConcurrencyPoolProperties, ProxyRestTemplatePool proxyRestTemplatePool) {
        return new DownloadFileTools(httpConcurrencyDownloadExecutor, beanFactory, fileProperties, httpConcurrencyPoolProperties, proxyRestTemplatePool);
    }

    @Bean
    public HttpSpider httpSpider(ProxyRestTemplatePool proxyRestTemplatePool, DownloadFileTools downloadFileTools) {
        return new HttpSpiderAdapter(proxyRestTemplatePool, downloadFileTools);
    }

    @Bean
    public ByteArrayHttpMessageConverter spiderDownloadFileHttpMessageConverter(FileProperties fileProperties) {
        ByteArrayHttpMessageConverter byteArrayHttpMessageConverter = new ByteArrayHttpMessageConverter();
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        list.add(MediaType.APPLICATION_OCTET_STREAM);
        Set<String> types = fileProperties.getMediaTypes();
        for (String type : types) {
            list.add(MediaType.valueOf((String)type));
        }
        byteArrayHttpMessageConverter.setSupportedMediaTypes(list);
        return byteArrayHttpMessageConverter;
    }
}

