/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.jkcode.jkmvc.db.Db;
import net.jkcode.jkmvc.db.DbColumn;
import net.jkcode.jkmvc.util.ModelGenerator;
import net.jkcode.jkutil.common.Config;
import net.jkcode.jkutil.common._DateKt;
import net.jkcode.jkutil.common._FileKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u001aH\u0002R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u001b"}, d2={"Lnet/jkcode/jkmvc/util/ModelGenerator;", "", "srcDir", "", "pck", "dbName", "author", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAuthor", "()Ljava/lang/String;", "config", "Lnet/jkcode/jkutil/common/Config;", "db", "Lnet/jkcode/jkmvc/db/Db;", "getDbName", "getPck", "getSrcDir", "genenateModelClass", "model", "label", "table", "genenateModelFile", "", "getProp", "column", "getType", "Lnet/jkcode/jkmvc/db/DbColumn;", "jkmvc-orm"})
public final class ModelGenerator {
    private final Db db;
    private final Config config;
    @NotNull
    private final String srcDir;
    @NotNull
    private final String pck;
    @NotNull
    private final String dbName;
    @NotNull
    private final String author;

    private final String getProp(String column) {
        return this.db.column2Prop(column);
    }

    private final String getType(DbColumn column) {
        Class<?> clazz = column.getLogicType().toJavaType(true, column.getPrecision(), column.getScale());
        String string = clazz.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"clazz.name");
        return StringsKt.replace$default((String)string, (String)"java.lang.", (String)"", (boolean)false, (int)4, null);
    }

    public final boolean genenateModelFile(@NotNull String model, @NotNull String label, @NotNull String table) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String dir = StringsKt.replace$default((String)(this.srcDir + '/' + this.pck), (char)'.', (char)'/', (boolean)false, (int)4, null);
        _FileKt.prepareDirectory((String)dir);
        String path = dir + '/' + model + ".kt";
        File f = new File(path);
        if (f.exists()) {
            String string = "\u751f\u6210" + model + "\u6a21\u578b\u6587\u4ef6\u5931\u8d25: " + path + " \u6587\u4ef6\u5df2\u5b58\u5728";
            System.out.println((Object)string);
            return false;
        }
        String code = this.genenateModelClass(model, label, table);
        f.createNewFile();
        FilesKt.writeText$default((File)f, (String)code, null, (int)2, null);
        String string = "\u751f\u6210" + model + "\u6a21\u578b\u6587\u4ef6: " + path;
        System.out.println((Object)string);
        return true;
    }

    @NotNull
    public final String genenateModelClass(@NotNull String model, @NotNull String label, @NotNull String table) {
        String type;
        String name;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        Collection<DbColumn> fields = this.db.getColumnsByTable(table).values();
        ArrayList<Pair> pks = new ArrayList<Pair>();
        for (DbColumn field : fields) {
            if (!Intrinsics.areEqual((Object)field.getName(), (Object)"PRI")) continue;
            name = field.getName();
            type = this.getType(field);
            pks.add(TuplesKt.to((Object)name, (Object)type));
        }
        StringBuilder code = new StringBuilder();
        String date = _DateKt.format$default((Date)new Date(), null, (int)1, null);
        code.append("package " + this.pck + " \n\n");
        code.append("import net.jkcode.jkmvc.orm.* \nimport java.util.*\n\n");
        code.append("/**\n * " + label + "\n *\n * @author shijianhang<772910474@qq.com>\n * @date " + date + "\n */\n");
        code.append("class " + model);
        if (pks.size() == 1) {
            Pair pair = (Pair)CollectionsKt.first((List)pks);
            name = (String)pair.component1();
            type = (String)pair.component2();
            code.append('(' + this.getProp(name) + ':' + type + "? = null): Orm(" + this.getProp(name) + ") {\n");
        } else {
            code.append("(vararg pks: Any): Orm(*pks) {\n\n");
            CollectionsKt.joinTo$default((Iterable)pks, (Appendable)code, (CharSequence)", ", (CharSequence)"\tpublic constructor(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, String>(this){
                final /* synthetic */ ModelGenerator this$0;

                @NotNull
                public final String invoke(@NotNull Pair<String, String> $name_type) {
                    Intrinsics.checkParameterIsNotNull($name_type, (String)"<name for destructuring parameter 0>");
                    String name = (String)$name_type.component1();
                    String type = (String)$name_type.component2();
                    return ModelGenerator.access$getProp(this.this$0, name) + ": " + type;
                }
                {
                    this.this$0 = modelGenerator;
                    super(1);
                }
            }), (int)48, null);
            CollectionsKt.joinTo$default((Iterable)pks, (Appendable)code, (CharSequence)", ", (CharSequence)" : this(*arrayOf(", (CharSequence)"))\n\n", (int)0, null, (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, String>(this){
                final /* synthetic */ ModelGenerator this$0;

                @NotNull
                public final String invoke(@NotNull Pair<String, String> $name_type) {
                    Intrinsics.checkParameterIsNotNull($name_type, (String)"<name for destructuring parameter 0>");
                    String name = (String)$name_type.component1();
                    String type = (String)$name_type.component2();
                    return ModelGenerator.access$getProp(this.this$0, name);
                }
                {
                    this.this$0 = modelGenerator;
                    super(1);
                }
            }), (int)48, null);
        }
        String pkMeta2 = pks.size() == 1 ? '\"' + (String)((Pair)CollectionsKt.first((List)pks)).getFirst() + '\"' : CollectionsKt.joinToString$default((Iterable)pks, (CharSequence)", ", (CharSequence)"DbKeyNames(", (CharSequence)")", (int)0, null, (Function1)genenateModelClass.pkMeta.1.INSTANCE, (int)24, null);
        code.append("\t// \u4f34\u968f\u5bf9\u8c61\u5c31\u662f\u5143\u6570\u636e\n \tcompanion object m: OrmMeta(" + model + "::class, \"" + label + "\", \"" + table + "\", " + pkMeta2 + "){}\n\n");
        code.append("\t// \u4ee3\u7406\u5c5e\u6027\u8bfb\u5199");
        for (DbColumn field : fields) {
            String name2 = this.getProp(field.getName());
            String type2 = this.getType(field);
            String comment = field.getComment();
            code.append("\n\tpublic var " + name2 + ':' + type2 + " by property() // " + comment + " \n");
        }
        code.append("\n}");
        String string = code.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"code.toString()");
        return string;
    }

    @NotNull
    public final String getSrcDir() {
        return this.srcDir;
    }

    @NotNull
    public final String getPck() {
        return this.pck;
    }

    @NotNull
    public final String getDbName() {
        return this.dbName;
    }

    @NotNull
    public final String getAuthor() {
        return this.author;
    }

    public ModelGenerator(@NotNull String srcDir, @NotNull String pck, @NotNull String dbName, @NotNull String author) {
        Intrinsics.checkParameterIsNotNull((Object)srcDir, (String)"srcDir");
        Intrinsics.checkParameterIsNotNull((Object)pck, (String)"pck");
        Intrinsics.checkParameterIsNotNull((Object)dbName, (String)"dbName");
        Intrinsics.checkParameterIsNotNull((Object)author, (String)"author");
        this.srcDir = srcDir;
        this.pck = pck;
        this.dbName = dbName;
        this.author = author;
        this.db = Db.Companion.instance(this.dbName);
        this.config = Config.Companion.instance$default((Config.Companion)Config.Companion, (String)("db-meta." + (Object)((Object)this.db.getDbType())), (String)"yaml", (boolean)false, (int)4, null);
    }

    public /* synthetic */ ModelGenerator(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = "default";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        this(string, string2, string3, string4);
    }

    public static final /* synthetic */ String access$getProp(ModelGenerator $this, String column) {
        return $this.getProp(column);
    }
}

