/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.query;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.jkcode.jkmvc.db.DbException;
import net.jkcode.jkmvc.query.IDbQueryBuilder;
import net.jkcode.jkutil.common._ReflectKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0011\u001a\u00020\u00002\u0010\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\u0004\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0011\u001a\u00020\u00002\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0014J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0006\u0010\u001b\u001a\u00020\u0018J\b\u0010\u001c\u001a\u00020\rH\u0016J\u0006\u0010\u001d\u001a\u00020\u0016J\u0006\u0010\u001e\u001a\u00020\u001fR\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR%\u0010\u000b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\r0\fj\n\u0012\u0006\u0012\u0004\u0018\u00010\r`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lnet/jkcode/jkmvc/query/InsertData;", "", "()V", "columns", "", "", "getColumns", "()[Ljava/lang/String;", "setColumns", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "rows", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getRows", "()Ljava/util/ArrayList;", "add", "row", "([Ljava/lang/Object;)Lnet/jkcode/jkmvc/query/InsertData;", "", "subquery", "Lnet/jkcode/jkmvc/query/IDbQueryBuilder;", "checkRowSize", "", "rowSize", "", "clear", "clone", "getSubQuery", "isSubQuery", "", "jkmvc-orm"})
public final class InsertData
implements Cloneable {
    @NotNull
    private String[] columns;
    @NotNull
    private final ArrayList<Object> rows;

    @NotNull
    public final String[] getColumns() {
        return this.columns;
    }

    public final void setColumns(@NotNull String[] stringArray) {
        Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"<set-?>");
        this.columns = stringArray;
    }

    @NotNull
    public final ArrayList<Object> getRows() {
        return this.rows;
    }

    protected final void checkRowSize(int rowSize) {
        if (this.isSubQuery()) {
            throw (Throwable)((Object)new DbException("Already insert sub query\uff0c you cannot insert other value", null, 2, null));
        }
        String[] stringArray = this.columns;
        if (stringArray.length == 0) {
            throw (Throwable)((Object)new DbException("Must call insertColumn() to set inserting fields first", null, 2, null));
        }
        int columnSize = this.columns.length;
        if (rowSize % columnSize != 0) {
            throw (Throwable)new IllegalArgumentException("The inserting value size [" + rowSize + "], mismatch inserting fields size [" + columnSize + ']');
        }
    }

    public final boolean isSubQuery() {
        Collection collection = this.rows;
        return !collection.isEmpty() && this.rows.get(0) instanceof IDbQueryBuilder;
    }

    @NotNull
    public final IDbQueryBuilder getSubQuery() {
        Object object = this.rows.get(0);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.jkcode.jkmvc.query.IDbQueryBuilder");
        }
        return (IDbQueryBuilder)object;
    }

    @NotNull
    public final InsertData add(@NotNull Object[] row) {
        Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
        this.checkRowSize(row.length);
        CollectionsKt.addAll((Collection)this.rows, (Object[])row);
        return this;
    }

    @NotNull
    public final InsertData add(@NotNull IDbQueryBuilder subquery) {
        Intrinsics.checkParameterIsNotNull((Object)subquery, (String)"subquery");
        Collection collection = this.rows;
        if (!collection.isEmpty()) {
            throw (Throwable)((Object)new DbException("Already insert some value\uff0c you cannot insert sub query", null, 2, null));
        }
        this.rows.add(subquery);
        return this;
    }

    @NotNull
    public final InsertData add(@NotNull Collection<? extends Object> row) {
        Intrinsics.checkParameterIsNotNull(row, (String)"row");
        this.checkRowSize(row.size());
        this.rows.addAll(row);
        return this;
    }

    public final void clear() {
        InsertData insertData = this;
        String[] stringArray = new String[]{};
        insertData.columns = stringArray;
        this.rows.clear();
    }

    @NotNull
    public Object clone() {
        Object o = super.clone();
        _ReflectKt.cloneProperties((Object)o, (String[])new String[]{"columns", "rows"});
        return o;
    }

    public InsertData() {
        InsertData insertData = this;
        String[] stringArray = new String[]{};
        insertData.columns = stringArray;
        this.rows = new ArrayList();
    }
}

