/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.query;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.jkcode.jkmvc.db.DbType;
import net.jkcode.jkmvc.db.IDb;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lnet/jkcode/jkmvc/query/DbLimit;", "", "limit", "", "offset", "(II)V", "getLimit", "()I", "getOffset", "compile", "", "db", "Lnet/jkcode/jkmvc/db/IDb;", "sql", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "jkmvc-orm"})
public final class DbLimit {
    private final int limit;
    private final int offset;

    public final void compile(@NotNull IDb db, @NotNull StringBuilder sql) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        if (db.getDbType() == DbType.Oracle) {
            sql.insert(0, "SELECT t1_.*, rownum rownum_ FROM ( ").append(") t1_ WHERE rownum <  ").append(this.limit + this.offset);
            if (this.offset > 0) {
                sql.insert(0, "SELECT * FROM ( ").append(" ) t2_ WHERE t2_.rownum_ >=  ").append(this.offset);
            }
            return;
        }
        if (db.getDbType() == DbType.SqlServer) {
            int iSelect = "SELECT".length();
            if (this.offset == 0) {
                sql.insert(iSelect, " TOP " + this.limit);
            } else {
                int iOrderBy = sql.indexOf("ORDER BY");
                String orderBy = "ORDER BY ID";
                if (iOrderBy != -1) {
                    String string = sql.substring(iOrderBy);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sql.substring(iOrderBy)");
                    orderBy = string;
                    sql.delete(iOrderBy, sql.length());
                }
                sql.insert(iSelect, "* FROM ( SELECT ROW_NUMBER() OVER ( " + orderBy + " ) as rownum_, ").append(") t_ WHERE rownum_ >= ").append(this.limit).append(" AND rownum_ < ").append(this.offset + this.limit);
            }
            return;
        }
        if (db.getDbType() == DbType.Postgresql) {
            sql.append(" LIMIT ").append(this.limit);
            if (this.offset > 0) {
                sql.append(" OFFSET ").append(this.offset);
            }
            return;
        }
        if (this.offset == 0) {
            sql.append(" LIMIT ").append(this.limit);
        } else {
            sql.append(" LIMIT ").append(this.offset).append(", ").append(this.limit);
        }
    }

    public final int getLimit() {
        return this.limit;
    }

    public final int getOffset() {
        return this.offset;
    }

    public DbLimit(int limit, int offset) {
        this.limit = limit;
        this.offset = offset;
    }

    public final int component1() {
        return this.limit;
    }

    public final int component2() {
        return this.offset;
    }

    @NotNull
    public final DbLimit copy(int limit, int offset) {
        return new DbLimit(limit, offset);
    }

    @NotNull
    public static /* synthetic */ DbLimit copy$default(DbLimit dbLimit, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = dbLimit.limit;
        }
        if ((n3 & 2) != 0) {
            n2 = dbLimit.offset;
        }
        return dbLimit.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "DbLimit(limit=" + this.limit + ", offset=" + this.offset + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.limit) * 31 + Integer.hashCode(this.offset);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DbLimit)) break block3;
                DbLimit dbLimit = (DbLimit)object;
                if (!(this.limit == dbLimit.limit) || !(this.offset == dbLimit.offset)) break block3;
            }
            return true;
        }
        return false;
    }
}

