/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.es;

import io.searchbox.client.JestResult;
import io.searchbox.core.SearchResult;
import java.io.Closeable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import net.jkcode.jkmvc.es.EsException;
import net.jkcode.jkmvc.es.EsManager;
import net.jkcode.jkmvc.es._JestKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\"B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\n\u00a2\u0006\u0002\u0010\rJ\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0096\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lnet/jkcode/jkmvc/es/EsScrollCollection;", "T", "Ljava/util/AbstractCollection;", "esMgr", "Lnet/jkcode/jkmvc/es/EsManager;", "result", "Lio/searchbox/core/SearchResult;", "scrollTimeInMillis", "", "resultMapper", "Lkotlin/Function1;", "Lio/searchbox/client/JestResult;", "", "(Lnet/jkcode/jkmvc/es/EsManager;Lio/searchbox/core/SearchResult;JLkotlin/jvm/functions/Function1;)V", "getEsMgr", "()Lnet/jkcode/jkmvc/es/EsManager;", "iterateCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getIterateCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setIterateCount", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "getResult", "()Lio/searchbox/core/SearchResult;", "getResultMapper", "()Lkotlin/jvm/functions/Function1;", "getScrollTimeInMillis", "()J", "size", "", "getSize", "()I", "iterator", "", "ScrollIterator", "jkmvc-orm"})
public final class EsScrollCollection<T>
extends AbstractCollection<T> {
    @NotNull
    private AtomicInteger iterateCount;
    private final int size;
    @NotNull
    private final EsManager esMgr;
    @NotNull
    private final SearchResult result;
    private final long scrollTimeInMillis;
    @NotNull
    private final Function1<JestResult, Collection<T>> resultMapper;

    @NotNull
    protected final AtomicInteger getIterateCount() {
        return this.iterateCount;
    }

    protected final void setIterateCount(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkParameterIsNotNull((Object)atomicInteger, (String)"<set-?>");
        this.iterateCount = atomicInteger;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        if (this.iterateCount.getAndIncrement() > 0) {
            throw (Throwable)((Object)new EsException("EsScrollCollection \u53ea\u80fd\u8fed\u4ee3\u4e00\u6b21", null, 2, null));
        }
        return new ScrollIterator((JestResult)this.result);
    }

    @NotNull
    protected final EsManager getEsMgr() {
        return this.esMgr;
    }

    @NotNull
    protected final SearchResult getResult() {
        return this.result;
    }

    protected final long getScrollTimeInMillis() {
        return this.scrollTimeInMillis;
    }

    @NotNull
    protected final Function1<JestResult, Collection<T>> getResultMapper() {
        return this.resultMapper;
    }

    public EsScrollCollection(@NotNull EsManager esMgr, @NotNull SearchResult result, long scrollTimeInMillis, @NotNull Function1<? super JestResult, ? extends Collection<? extends T>> resultMapper) {
        Intrinsics.checkParameterIsNotNull((Object)esMgr, (String)"esMgr");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull(resultMapper, (String)"resultMapper");
        this.esMgr = esMgr;
        this.result = result;
        this.scrollTimeInMillis = scrollTimeInMillis;
        this.resultMapper = resultMapper;
        this.iterateCount = new AtomicInteger(0);
        this.size = (int)this.result.getTotal().longValue();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0011H\u0096\u0002J\u000e\u0010\u001b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0019H\u0004J\b\u0010\u001e\u001a\u00020\u0019H\u0016R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lnet/jkcode/jkmvc/es/EsScrollCollection$ScrollIterator;", "", "Ljava/io/Closeable;", "currResult", "Lio/searchbox/client/JestResult;", "(Lnet/jkcode/jkmvc/es/EsScrollCollection;Lio/searchbox/client/JestResult;)V", "currHits", "", "getCurrHits", "()Ljava/util/Iterator;", "setCurrHits", "(Ljava/util/Iterator;)V", "getCurrResult", "()Lio/searchbox/client/JestResult;", "setCurrResult", "(Lio/searchbox/client/JestResult;)V", "finished", "", "scrollId", "", "getScrollId", "()Ljava/lang/String;", "setScrollId", "(Ljava/lang/String;)V", "close", "", "hasNext", "next", "()Ljava/lang/Object;", "onToggleResult", "remove", "jkmvc-orm"})
    public final class ScrollIterator
    implements Iterator<T>,
    Closeable,
    KMutableIterator {
        @Nullable
        private Iterator<? extends T> currHits;
        @Nullable
        private String scrollId;
        private boolean finished;
        @NotNull
        private JestResult currResult;

        @Nullable
        protected final Iterator<T> getCurrHits() {
            return this.currHits;
        }

        protected final void setCurrHits(@Nullable Iterator<? extends T> iterator) {
            this.currHits = iterator;
        }

        @Nullable
        protected final String getScrollId() {
            return this.scrollId;
        }

        protected final void setScrollId(@Nullable String string) {
            this.scrollId = string;
        }

        protected final void onToggleResult() {
            Function1 function1 = EsScrollCollection.this.getResultMapper();
            JestResult jestResult = this.currResult;
            if (jestResult == null) {
                Intrinsics.throwNpe();
            }
            this.currHits = ((Collection)function1.invoke((Object)jestResult)).iterator();
            Iterator iterator = this.currHits;
            if (iterator == null) {
                Intrinsics.throwNpe();
            }
            this.finished = !iterator.hasNext();
            this.scrollId = _JestKt.getScrollId(this.currResult);
            if (this.finished) {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                if (this.scrollId != null) {
                    EsManager esManager = EsScrollCollection.this.getEsMgr();
                    String string = this.scrollId;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    esManager.clearScroll(string);
                }
            }
            finally {
                this.currHits = null;
                this.scrollId = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.finished) {
                return false;
            }
            if (this.currHits != null) {
                Iterator iterator = this.currHits;
                if (iterator == null) {
                    Intrinsics.throwNpe();
                }
                if (!iterator.hasNext()) {
                    EsManager esManager = EsScrollCollection.this.getEsMgr();
                    String string = this.scrollId;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    this.currResult = esManager.continueScroll$jkmvc_orm(string, EsScrollCollection.this.getScrollTimeInMillis());
                    this.onToggleResult();
                }
            }
            Iterator iterator = this.currHits;
            return iterator != null ? iterator.hasNext() : false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                Iterator iterator = this.currHits;
                if (iterator == null) {
                    Intrinsics.throwNpe();
                }
                return iterator.next();
            }
            throw (Throwable)new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw (Throwable)new UnsupportedOperationException("remove");
        }

        @NotNull
        protected final JestResult getCurrResult() {
            return this.currResult;
        }

        protected final void setCurrResult(@NotNull JestResult jestResult) {
            Intrinsics.checkParameterIsNotNull((Object)jestResult, (String)"<set-?>");
            this.currResult = jestResult;
        }

        public ScrollIterator(JestResult currResult) {
            Intrinsics.checkParameterIsNotNull((Object)currResult, (String)"currResult");
            this.currResult = currResult;
            this.finished = true;
            this.onToggleResult();
        }
    }
}

