/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.db;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.jkcode.jkmvc.db.Db;
import net.jkcode.jkmvc.db.DbColumn;
import net.jkcode.jkmvc.db.DbConfig;
import net.jkcode.jkmvc.db.DbMeta;
import net.jkcode.jkmvc.db.DbResultRow;
import net.jkcode.jkmvc.db.DbResultSet;
import net.jkcode.jkmvc.db.DbTable;
import net.jkcode.jkmvc.db.DbType;
import net.jkcode.jkmvc.db.IDb;
import net.jkcode.jkmvc.db.IDbMeta;
import net.jkcode.jkmvc.db.sharding.ShardingDb;
import net.jkcode.jkmvc.db.single.DruidSingleDb;
import net.jkcode.jkutil.common.Config;
import net.jkcode.jkutil.common._LoggerKt;
import net.jkcode.jkutil.ttl.AllRequestScopedTransferableThreadLocal;
import net.jkcode.jkutil.ttl.ScopedTransferableThreadLocal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u0080\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0080\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010G\u001a\u00020\u00012\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020@0?H\u0016J(\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\t2\u000e\u0010L\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010N0M2\u0006\u0010O\u001a\u000208H\u0016J\b\u0010P\u001a\u00020@H\u0016J\u0006\u0010Q\u001a\u00020@J\u0011\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u00020\tH\u0096\u0001J\b\u0010T\u001a\u00020\u001cH\u0016J=\u0010U\u001a\u0004\u0018\u0001HV\"\u0004\b\u0000\u0010V2\u0006\u0010K\u001a\u00020\t2\n\u0010W\u001a\u0006\u0012\u0002\b\u00030M2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u0002HV0?H\u0016\u00a2\u0006\u0002\u0010ZJ&\u0010U\u001a\u00020[2\u0006\u0010K\u001a\u00020\t2\n\u0010W\u001a\u0006\u0012\u0002\b\u00030M2\b\u0010\\\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010]\u001a\u00020\u001cH\u0016J\u001d\u0010^\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020_032\u0006\u0010`\u001a\u00020\tH\u0096\u0001J\u0013\u0010a\u001a\u0004\u0018\u0001042\u0006\u0010`\u001a\u00020\tH\u0096\u0001J\b\u0010b\u001a\u00020@H$J\b\u0010c\u001a\u00020@H$J\b\u0010d\u001a\u00020@H$J\b\u0010e\u001a\u00020\u001cH\u0016J\u0011\u0010f\u001a\u00020\u001c2\u0006\u0010g\u001a\u00020\tH\u0096\u0001J\u001c\u0010h\u001a\u00020\t2\u0006\u0010K\u001a\u00020\t2\n\u0010W\u001a\u0006\u0012\u0002\b\u00030MH\u0016J\u0011\u0010i\u001a\u00020\t2\u0006\u0010j\u001a\u00020\tH\u0096\u0001J\u0019\u0010k\u001a\b\u0012\u0004\u0012\u00020_0M2\b\u0010`\u001a\u0004\u0018\u00010\tH\u0096\u0001J\u0017\u0010l\u001a\b\u0012\u0004\u0012\u00020\t0m2\u0006\u0010`\u001a\u00020\tH\u0096\u0001J;\u0010n\u001a\u0002HV\"\u0004\b\u0000\u0010V2\u0006\u0010K\u001a\u00020\t2\n\u0010W\u001a\u0006\u0012\u0002\b\u00030M2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u0002HV0?H\u0016\u00a2\u0006\u0002\u0010ZJ\u0011\u0010o\u001a\u00020\u001c2\u0006\u0010`\u001a\u00020\tH\u0096\u0001J\u0013\u0010p\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010NH\u0096\u0001J\u0011\u0010q\u001a\u00020\t2\u0006\u0010S\u001a\u00020\u0005H\u0096\u0001J\u0011\u0010r\u001a\u00020\t2\u0006\u0010s\u001a\u00020\tH\u0096\u0001J\u0013\u0010t\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010NH\u0096\u0001J\u0011\u0010u\u001a\u00020\t2\u0006\u0010`\u001a\u00020\u0005H\u0096\u0001J\u0011\u0010v\u001a\u00020\t2\u0006\u0010`\u001a\u00020\u0005H\u0096\u0001J\b\u0010w\u001a\u00020\u001cH\u0016J\u000e\u0010x\u001a\u00020@2\u0006\u0010y\u001a\u00020zJ\u000e\u0010x\u001a\u00020@2\u0006\u0010{\u001a\u00020\tJ6\u0010|\u001a\u0002HV\"\u0004\b\u0000\u0010V2\u0006\u0010K\u001a\u00020\t2\n\u0010W\u001a\u0006\u0012\u0002\b\u00030M2\f\u0010}\u001a\b\u0012\u0004\u0012\u0002HV0~H\u0084\b\u00a2\u0006\u0002\u0010\u007fR(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\fR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\fR\u0012\u0010#\u001a\u00020$X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0012\u0010'\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001e\"\u0004\b-\u0010 R\u0014\u0010.\u001a\u0004\u0018\u00010\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b/\u0010\fR\u0012\u00100\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0012R\u001e\u00102\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020403X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R-\u0010=\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020@0?0>8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bA\u0010BR\u0012\u0010E\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bF\u0010\f\u00a8\u0006\u0081\u0001"}, d2={"Lnet/jkcode/jkmvc/db/Db;", "Lnet/jkcode/jkmvc/db/IDb;", "Lnet/jkcode/jkmvc/db/IDbMeta;", "Ljava/io/Closeable;", "name", "", "dbMeta", "(Ljava/lang/CharSequence;Lnet/jkcode/jkmvc/db/IDbMeta;)V", "value", "", "catalog", "getCatalog", "()Ljava/lang/String;", "setCatalog", "(Ljava/lang/String;)V", "conn", "Ljava/sql/Connection;", "getConn", "()Ljava/sql/Connection;", "getDbMeta", "()Lnet/jkcode/jkmvc/db/IDbMeta;", "dbType", "Lnet/jkcode/jkmvc/db/DbType;", "getDbType", "()Lnet/jkcode/jkmvc/db/DbType;", "driverName", "getDriverName", "forceMaster", "", "getForceMaster", "()Z", "setForceMaster", "(Z)V", "identifierQuoteString", "getIdentifierQuoteString", "masterConfig", "Lnet/jkcode/jkutil/common/Config;", "getMasterConfig", "()Lnet/jkcode/jkutil/common/Config;", "masterConn", "getMasterConn", "getName", "()Ljava/lang/CharSequence;", "rollbacked", "getRollbacked", "setRollbacked", "schema", "getSchema", "slaveConn", "getSlaveConn", "tables", "", "Lnet/jkcode/jkmvc/db/DbTable;", "getTables", "()Ljava/util/Map;", "transDepth", "", "getTransDepth", "()I", "setTransDepth", "(I)V", "transactionCallbacks", "", "Lkotlin/Function1;", "", "getTransactionCallbacks", "()Ljava/util/List;", "transactionCallbacks$delegate", "Lkotlin/Lazy;", "url", "getUrl", "addTransactionCallback", "callback", "batchExecute", "", "sql", "paramses", "", "", "paramSize", "begin", "closeAndClear", "column2Prop", "column", "commit", "execute", "T", "params", "transform", "Lnet/jkcode/jkmvc/db/DbResultSet;", "(Ljava/lang/String;Ljava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "", "generatedColumn", "f", "getColumnsByTable", "Lnet/jkcode/jkmvc/db/DbColumn;", "table", "getTable", "handleBegin", "handleCommit", "handleRollback", "isInTransaction", "isKeyword", "col", "previewSql", "prop2Column", "prop", "queryColumnsByTable", "queryPrimaryKeysByTable", "", "queryResult", "queryTableExist", "quote", "quoteColumn", "quoteIdentifier", "id", "quoteSingleValue", "quoteTable", "quoteTableAlias", "rollback", "runScript", "input", "Ljava/io/InputStream;", "script", "tryExecute", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/util/List;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "jkmvc-orm"})
public abstract class Db
extends IDb
implements IDbMeta,
Closeable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private boolean forceMaster;
    private int transDepth;
    private boolean rollbacked;
    @NotNull
    private final Lazy transactionCallbacks$delegate;
    @NotNull
    private final CharSequence name;
    @NotNull
    private final IDbMeta dbMeta;
    @NotNull
    private static final AllRequestScopedTransferableThreadLocal<HashMap<CharSequence, Db>> dbs;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Db.class), "transactionCallbacks", "getTransactionCallbacks()Ljava/util/List;"))};
        Companion = new Companion(null);
        dbs = (AllRequestScopedTransferableThreadLocal)new AllRequestScopedTransferableThreadLocal<HashMap<CharSequence, Db>>((Function0)Companion.dbs.2.INSTANCE){

            public void endScope() {
                HashMap dbs2 = (HashMap)ScopedTransferableThreadLocal.get$default((ScopedTransferableThreadLocal)this, (boolean)false, (int)1, null);
                Map map2 = dbs2;
                Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> entry;
                    Map.Entry<K, V> entry2 = entry = iterator.next();
                    CharSequence name = (CharSequence)entry2.getKey();
                    entry2 = entry;
                    Db db = (Db)entry2.getValue();
                    db.close();
                }
                dbs2.clear();
                super.endScope();
            }
        };
    }

    @NotNull
    protected abstract Connection getMasterConn();

    @NotNull
    protected abstract Connection getSlaveConn();

    public final boolean getForceMaster() {
        return this.forceMaster;
    }

    public final void setForceMaster(boolean bl) {
        this.forceMaster = bl;
    }

    @NotNull
    public final Connection getConn() {
        if (this.isInTransaction() || this.forceMaster) {
            return this.getMasterConn();
        }
        return this.getSlaveConn();
    }

    @Override
    @Nullable
    public String getCatalog() {
        return this.getConn().getCatalog();
    }

    public void setCatalog(@Nullable String value) {
        this.getConn().setCatalog(value);
    }

    protected final int getTransDepth() {
        return this.transDepth;
    }

    protected final void setTransDepth(int n) {
        this.transDepth = n;
    }

    protected final boolean getRollbacked() {
        return this.rollbacked;
    }

    protected final void setRollbacked(boolean bl) {
        this.rollbacked = bl;
    }

    @NotNull
    protected final List<Function1<Boolean, Unit>> getTransactionCallbacks() {
        Lazy lazy = this.transactionCallbacks$delegate;
        Db db = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public IDb forceMaster(boolean f) {
        this.forceMaster = f;
        return this;
    }

    @Override
    @NotNull
    public IDb addTransactionCallback(@NotNull Function1<? super Boolean, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.getTransactionCallbacks().add(callback);
        return this;
    }

    protected abstract void handleBegin();

    protected abstract void handleCommit();

    protected abstract void handleRollback();

    @Override
    public void begin() {
        int n = this.transDepth;
        this.transDepth = n + 1;
        if (n == 0) {
            this.handleBegin();
        }
    }

    @Override
    public boolean commit() {
        if (this.transDepth <= 0) {
            return false;
        }
        Db db = this;
        db.transDepth += -1;
        if (db.transDepth == 0) {
            if (this.rollbacked) {
                this.handleRollback();
            } else {
                this.handleCommit();
            }
            boolean result = !this.rollbacked;
            Iterable $receiver$iv = this.getTransactionCallbacks();
            for (Object element$iv : $receiver$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)result);
            }
            this.rollbacked = false;
            return result;
        }
        return true;
    }

    @Override
    public boolean rollback() {
        if (this.transDepth <= 0) {
            return false;
        }
        Db db = this;
        db.transDepth += -1;
        if (db.transDepth == 0) {
            this.rollbacked = false;
            this.handleRollback();
            Iterable $receiver$iv = this.getTransactionCallbacks();
            for (Object element$iv : $receiver$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)false);
            }
        }
        this.rollbacked = true;
        return true;
    }

    @Override
    public boolean isInTransaction() {
        return this.transDepth > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String previewSql(@NotNull String sql, @NotNull List<?> params2) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params2, (String)"params");
        if (params2.isEmpty()) {
            return sql;
        }
        Collection $receiver$iv = params2;
        boolean $i$f$mapToArray = false;
        String[] arr$iv = new String[$receiver$iv.size()];
        int i$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void it;
            String string;
            int n = i$iv++;
            Object e = item$iv;
            int n2 = n;
            String[] stringArray = arr$iv;
            boolean bl = false;
            stringArray[n2] = string = this.quote(it);
        }
        String[] ps = arr$iv;
        String string = StringsKt.replace$default((String)sql, (String)"?", (String)"%s", (boolean)false, (int)4, null);
        String[] stringArray = Arrays.copyOf(ps, ps.length);
        String string2 = String.format(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    protected final <T> T tryExecute(@NotNull String sql, @NotNull List<?> params2, @NotNull Function0<? extends T> action) {
        int $i$f$tryExecute = 0;
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params2, (String)"params");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        try {
            Object result = action.invoke();
            if (_LoggerKt.getDbLogger().isDebugEnabled()) {
                _LoggerKt.getDbLogger().debug("Execute sql: {}", (Object)this.previewSql(sql, params2));
            }
            return (T)result;
        }
        catch (SQLException e) {
            _LoggerKt.getDbLogger().error("Error [{}] on sql: {}", (Object)e.getMessage(), (Object)this.previewSql(sql, params2));
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public long execute(@NotNull String sql, @NotNull List<?> params2, @Nullable String generatedColumn) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params2, (String)"params");
        Db this_$iv = this;
        boolean $i$f$tryExecute = false;
        try {
            long l2;
            block18: {
                int rows$iv;
                PreparedStatement pst$iv;
                block16: {
                    long l3;
                    boolean bl = false;
                    Connection connection = this.getMasterConn();
                    String string = sql;
                    List<?> list = params2;
                    String generatedColumn$iv = generatedColumn;
                    boolean $i$f$execute = false;
                    pst$iv = null;
                    try {
                        long l4;
                        void params$iv;
                        void sql$iv;
                        void $receiver$iv;
                        PreparedStatement preparedStatement = pst$iv = generatedColumn$iv == null ? $receiver$iv.prepareStatement((String)sql$iv) : $receiver$iv.prepareStatement((String)sql$iv, new String[]{generatedColumn$iv});
                        Intrinsics.checkExpressionValueIsNotNull((Object)preparedStatement, (String)"pst");
                        PreparedStatement $receiver$iv$iv = preparedStatement;
                        int start$iv$iv = 0;
                        int length$iv$iv = params$iv.size();
                        boolean $i$f$setParameters = false;
                        if (length$iv$iv < 0 || length$iv$iv > params$iv.size()) {
                            throw (Throwable)new IllegalArgumentException("Mismatch `PreparedStatement` parameter size\uff1a It needs [" + length$iv$iv + "], but pass [" + params$iv.size() + ']');
                        }
                        int n = 0;
                        int n2 = length$iv$iv - 1;
                        if (n <= n2) {
                            while (true) {
                                void i$iv$iv;
                                Object value$iv$iv;
                                if ((value$iv$iv = params$iv.get(start$iv$iv + i$iv$iv)) instanceof Enum) {
                                    value$iv$iv = ((Enum)value$iv$iv).ordinal();
                                }
                                if (value$iv$iv instanceof java.util.Date && !(value$iv$iv instanceof Date) && !(value$iv$iv instanceof Timestamp) && !(value$iv$iv instanceof Time)) {
                                    value$iv$iv = new Timestamp(((java.util.Date)value$iv$iv).getTime());
                                }
                                $receiver$iv$iv.setObject(1 + i$iv$iv, value$iv$iv);
                                if (i$iv$iv == n2) break;
                                ++i$iv$iv;
                            }
                        }
                        rows$iv = pst$iv.executeUpdate();
                        if (generatedColumn$iv == null) break block16;
                        PreparedStatement $receiver$iv$iv2 = pst$iv;
                        boolean $i$f$getGeneratedKey = false;
                        ResultSet rs$iv$iv = null;
                        try {
                            rs$iv$iv = $receiver$iv$iv2.getGeneratedKeys();
                            rs$iv$iv.next();
                            l4 = rs$iv$iv.getLong(1);
                        }
                        finally {
                            ResultSet resultSet = rs$iv$iv;
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        l3 = l4;
                    }
                    catch (Throwable throwable) {
                        PreparedStatement preparedStatement = pst$iv;
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        throw throwable;
                    }
                    pst$iv.close();
                    l2 = l3;
                    break block18;
                }
                long l5 = rows$iv;
                pst$iv.close();
                l2 = l5;
            }
            long result$iv = l2;
            if (_LoggerKt.getDbLogger().isDebugEnabled()) {
                _LoggerKt.getDbLogger().debug("Execute sql: {}", (Object)this_$iv.previewSql(sql, params2));
            }
            l = result$iv;
        }
        catch (SQLException e$iv) {
            _LoggerKt.getDbLogger().error("Error [{}] on sql: {}", (Object)e$iv.getMessage(), (Object)this_$iv.previewSql(sql, params2));
            throw (Throwable)e$iv;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <T> T execute(@NotNull String sql, @NotNull List<?> params2, @NotNull Function1<? super DbResultSet, ? extends T> transform) {
        AutoCloseable autoCloseable;
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params2, (String)"params");
        Intrinsics.checkParameterIsNotNull(transform, (String)"transform");
        Db this_$iv = this;
        boolean $i$f$tryExecute = false;
        try {
            AutoCloseable autoCloseable2;
            boolean bl = false;
            Connection connection = this.getMasterConn();
            String string = sql;
            List<?> params$iv = params2;
            boolean $i$f$execute = false;
            PreparedStatement pst$iv = null;
            try {
                Object object;
                ResultSet rs$iv;
                void sql$iv;
                void $receiver$iv;
                PreparedStatement preparedStatement = pst$iv = $receiver$iv.prepareStatement((String)sql$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)preparedStatement, (String)"pst");
                PreparedStatement $receiver$iv$iv = preparedStatement;
                int start$iv$iv = 0;
                int length$iv$iv = params$iv.size();
                boolean $i$f$setParameters = false;
                if (length$iv$iv < 0 || length$iv$iv > params$iv.size()) {
                    throw (Throwable)new IllegalArgumentException("Mismatch `PreparedStatement` parameter size\uff1a It needs [" + length$iv$iv + "], but pass [" + params$iv.size() + ']');
                }
                int n = 0;
                int n2 = length$iv$iv - 1;
                if (n <= n2) {
                    while (true) {
                        void i$iv$iv;
                        Object value$iv$iv;
                        if ((value$iv$iv = params$iv.get(start$iv$iv + i$iv$iv)) instanceof Enum) {
                            value$iv$iv = ((Enum)value$iv$iv).ordinal();
                        }
                        if (value$iv$iv instanceof java.util.Date && !(value$iv$iv instanceof Date) && !(value$iv$iv instanceof Timestamp) && !(value$iv$iv instanceof Time)) {
                            value$iv$iv = new Timestamp(((java.util.Date)value$iv$iv).getTime());
                        }
                        $receiver$iv$iv.setObject(1 + i$iv$iv, value$iv$iv);
                        if (i$iv$iv == n2) break;
                        ++i$iv$iv;
                    }
                }
                pst$iv.executeUpdate();
                ResultSet resultSet = rs$iv = pst$iv.getResultSet();
                if (resultSet != null) {
                    autoCloseable2 = resultSet;
                    Throwable throwable = null;
                    try {
                        ResultSet it$iv = (ResultSet)autoCloseable2;
                        boolean bl2 = false;
                        ResultSet it = it$iv;
                        boolean bl3 = false;
                        Object object2 = transform.invoke((Object)new DbResultSet(this, it));
                        object = object2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                    }
                } else {
                    object = null;
                }
                autoCloseable2 = object;
            }
            catch (Throwable throwable) {
                PreparedStatement preparedStatement = pst$iv;
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            pst$iv.close();
            AutoCloseable result$iv = autoCloseable2;
            if (_LoggerKt.getDbLogger().isDebugEnabled()) {
                _LoggerKt.getDbLogger().debug("Execute sql: {}", (Object)this_$iv.previewSql(sql, params2));
            }
            autoCloseable = result$iv;
        }
        catch (SQLException e$iv) {
            _LoggerKt.getDbLogger().error("Error [{}] on sql: {}", (Object)e$iv.getMessage(), (Object)this_$iv.previewSql(sql, params2));
            throw (Throwable)e$iv;
        }
        return (T)autoCloseable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public int[] batchExecute(@NotNull String sql, @NotNull List<? extends Object> paramses, int paramSize) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(paramses, (String)"paramses");
        try {
            int[] nArray;
            Connection $receiver$iv = this.getMasterConn();
            boolean $i$f$batchExecute = false;
            if (paramSize <= 0 || paramses.size() % paramSize > 0) {
                throw (Throwable)new IllegalArgumentException("Mismatch `Connection.batchExecute()` parameter size\uff1aIt handles [" + paramSize + "] paramters once, and only accepts an integral multiple of [" + paramSize + "], but you pass [" + paramses.size() + ']');
            }
            int batchNum$iv = paramses.size() / paramSize;
            PreparedStatement pst$iv = null;
            try {
                pst$iv = $receiver$iv.prepareStatement(sql);
                int n = 0;
                int n2 = batchNum$iv - 1;
                if (n <= n2) {
                    while (true) {
                        void i$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pst$iv, (String)"pst");
                        void start$iv$iv = i$iv * paramSize;
                        boolean $i$f$setParameters = false;
                        if (paramSize < 0 || paramSize > paramses.size()) {
                            throw (Throwable)new IllegalArgumentException("Mismatch `PreparedStatement` parameter size\uff1a It needs [" + paramSize + "], but pass [" + paramses.size() + ']');
                        }
                        int n3 = 0;
                        int n4 = paramSize - 1;
                        if (n3 <= n4) {
                            while (true) {
                                void $receiver$iv$iv;
                                void i$iv$iv;
                                Object value$iv$iv;
                                if ((value$iv$iv = paramses.get((int)(start$iv$iv + i$iv$iv))) instanceof Enum) {
                                    value$iv$iv = ((Enum)value$iv$iv).ordinal();
                                }
                                if (value$iv$iv instanceof java.util.Date && !(value$iv$iv instanceof Date) && !(value$iv$iv instanceof Timestamp) && !(value$iv$iv instanceof Time)) {
                                    value$iv$iv = new Timestamp(((java.util.Date)value$iv$iv).getTime());
                                }
                                $receiver$iv$iv.setObject(1 + i$iv$iv, value$iv$iv);
                                if (i$iv$iv == n4) break;
                                ++i$iv$iv;
                            }
                        }
                        pst$iv.addBatch();
                        if (i$iv == n2) break;
                        ++i$iv;
                    }
                }
                int[] nArray2 = pst$iv.executeBatch();
                Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"pst.executeBatch()");
                nArray = nArray2;
            }
            finally {
                PreparedStatement preparedStatement = pst$iv;
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            int[] result = nArray;
            _LoggerKt.getDbLogger().debug("Execute sql={}, params={}", (Object)sql, paramses);
            return result;
        }
        catch (SQLException e) {
            _LoggerKt.getDbLogger().error("Error [{}], sql={}, params={}", new Object[]{e.getMessage(), sql, paramses});
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <T> T queryResult(@NotNull String sql, @NotNull List<?> params2, @NotNull Function1<? super DbResultSet, ? extends T> transform) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params2, (String)"params");
        Intrinsics.checkParameterIsNotNull(transform, (String)"transform");
        Db this_$iv = this;
        boolean $i$f$tryExecute = false;
        try {
            Object object2;
            boolean bl = false;
            Connection connection = this.getConn();
            String string = sql;
            List<?> params$iv = params2;
            boolean $i$f$queryResult = false;
            PreparedStatement pst$iv = null;
            ResultSet rs$iv = null;
            try {
                void sql$iv;
                void $receiver$iv;
                PreparedStatement preparedStatement = pst$iv = $receiver$iv.prepareStatement((String)sql$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)preparedStatement, (String)"pst");
                PreparedStatement $receiver$iv$iv = preparedStatement;
                int start$iv$iv = 0;
                int length$iv$iv = params$iv.size();
                boolean $i$f$setParameters = false;
                if (length$iv$iv < 0 || length$iv$iv > params$iv.size()) {
                    throw (Throwable)new IllegalArgumentException("Mismatch `PreparedStatement` parameter size\uff1a It needs [" + length$iv$iv + "], but pass [" + params$iv.size() + ']');
                }
                int n = 0;
                int n2 = length$iv$iv - 1;
                if (n <= n2) {
                    while (true) {
                        void i$iv$iv;
                        Object value$iv$iv;
                        if ((value$iv$iv = params$iv.get(start$iv$iv + i$iv$iv)) instanceof Enum) {
                            value$iv$iv = ((Enum)value$iv$iv).ordinal();
                        }
                        if (value$iv$iv instanceof java.util.Date && !(value$iv$iv instanceof Date) && !(value$iv$iv instanceof Timestamp) && !(value$iv$iv instanceof Time)) {
                            value$iv$iv = new Timestamp(((java.util.Date)value$iv$iv).getTime());
                        }
                        $receiver$iv$iv.setObject(1 + i$iv$iv, value$iv$iv);
                        if (i$iv$iv == n2) break;
                        ++i$iv$iv;
                    }
                }
                ResultSet resultSet = rs$iv = pst$iv.executeQuery();
                Intrinsics.checkExpressionValueIsNotNull((Object)resultSet, (String)"rs");
                ResultSet it = resultSet;
                boolean bl2 = false;
                object2 = transform.invoke((Object)new DbResultSet(this, it));
            }
            catch (Throwable throwable) {
                ResultSet resultSet = rs$iv;
                if (resultSet != null) {
                    resultSet.close();
                }
                PreparedStatement preparedStatement = pst$iv;
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            rs$iv.close();
            pst$iv.close();
            Object result$iv = object2;
            if (_LoggerKt.getDbLogger().isDebugEnabled()) {
                _LoggerKt.getDbLogger().debug("Execute sql: {}", (Object)this_$iv.previewSql(sql, params2));
            }
            object = result$iv;
        }
        catch (SQLException e$iv) {
            _LoggerKt.getDbLogger().error("Error [{}] on sql: {}", (Object)e$iv.getMessage(), (Object)this_$iv.previewSql(sql, params2));
            throw (Throwable)e$iv;
        }
        return (T)object;
    }

    public final void closeAndClear() {
        this.close();
        ((HashMap)ScopedTransferableThreadLocal.get$default(dbs, (boolean)false, (int)1, null)).remove(this.getName());
    }

    public final void runScript(@NotNull InputStream input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        InputStream inputStream = input;
        Charset charset = Charsets.UTF_8;
        String script = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
        this.runScript(script);
    }

    public final void runScript(@NotNull String script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        CharSequence charSequence = script;
        String string = "(^|\n) *--.*";
        string = new Regex(string);
        String string2 = "";
        String script2 = string.replace(charSequence, string2);
        string = ";\\s*\n";
        List sqls = Regex.split$default((Regex)new Regex(string), (CharSequence)script2, (int)0, (int)2, null);
        StringBuilder msg = new StringBuilder();
        this.transaction((Function0)new Function0<Unit>(this, sqls, msg){
            final /* synthetic */ Db this$0;
            final /* synthetic */ List $sqls;
            final /* synthetic */ StringBuilder $msg;

            public final void invoke() {
                for (String sql : this.$sqls) {
                    if (StringsKt.isBlank((CharSequence)sql)) continue;
                    IDb.execute$default((IDb)this.this$0, sql, null, (Function1)new Function1<DbResultSet, Unit>(this){
                        final /* synthetic */ runScript.1 this$0;

                        public final void invoke(@NotNull DbResultSet rs) {
                            Intrinsics.checkParameterIsNotNull((Object)rs, (String)"rs");
                            CollectionsKt.joinTo$default((Iterable)rs.getColumns(), (Appendable)this.this$0.$msg, (CharSequence)"\t", null, null, (int)0, null, null, (int)124, null);
                            Iterable $receiver$iv = rs;
                            for (T element$iv : $receiver$iv) {
                                DbResultRow r = (DbResultRow)element$iv;
                                boolean bl = false;
                                this.this$0.$msg.append("\n");
                                CollectionsKt.joinTo$default((Iterable)r, (Appendable)this.this$0.$msg, (CharSequence)"\t", null, null, (int)0, null, null, (int)124, null);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }, 2, null);
                }
            }
            {
                this.this$0 = db;
                this.$sqls = list;
                this.$msg = stringBuilder;
                super(0);
            }
        });
        _LoggerKt.getDbLogger().debug(msg.toString());
    }

    @Override
    @NotNull
    public CharSequence getName() {
        return this.name;
    }

    @Override
    @NotNull
    public IDbMeta getDbMeta() {
        return this.dbMeta;
    }

    protected Db(@NotNull CharSequence name, @NotNull IDbMeta dbMeta) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)dbMeta, (String)"dbMeta");
        this.name = name;
        this.dbMeta = dbMeta;
        this.transactionCallbacks$delegate = LazyKt.lazy((Function0)transactionCallbacks.2.INSTANCE);
    }

    public /* synthetic */ Db(CharSequence charSequence, IDbMeta iDbMeta, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iDbMeta = DbMeta.Companion.get(charSequence);
        }
        this(charSequence, iDbMeta);
    }

    @Override
    @NotNull
    public DbType getDbType() {
        return this.dbMeta.getDbType();
    }

    @Override
    @NotNull
    public String getDriverName() {
        return this.dbMeta.getDriverName();
    }

    @Override
    @NotNull
    public String getIdentifierQuoteString() {
        return this.dbMeta.getIdentifierQuoteString();
    }

    @Override
    @NotNull
    public Config getMasterConfig() {
        return this.dbMeta.getMasterConfig();
    }

    @Override
    @Nullable
    public String getSchema() {
        return this.dbMeta.getSchema();
    }

    @Override
    @NotNull
    public Map<String, DbTable> getTables() {
        return this.dbMeta.getTables();
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.dbMeta.getUrl();
    }

    @Override
    @NotNull
    public String column2Prop(@NotNull String column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        return this.dbMeta.column2Prop(column);
    }

    @Override
    @NotNull
    public Map<String, DbColumn> getColumnsByTable(@NotNull String table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return this.dbMeta.getColumnsByTable(table);
    }

    @Override
    @Nullable
    public DbTable getTable(@NotNull String table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return this.dbMeta.getTable(table);
    }

    @Override
    public boolean isKeyword(@NotNull String col) {
        Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
        return this.dbMeta.isKeyword(col);
    }

    @Override
    @NotNull
    public String prop2Column(@NotNull String prop) {
        Intrinsics.checkParameterIsNotNull((Object)prop, (String)"prop");
        return this.dbMeta.prop2Column(prop);
    }

    @Override
    @NotNull
    public List<DbColumn> queryColumnsByTable(@Nullable String table) {
        return this.dbMeta.queryColumnsByTable(table);
    }

    @Override
    @NotNull
    public Collection<String> queryPrimaryKeysByTable(@NotNull String table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return this.dbMeta.queryPrimaryKeysByTable(table);
    }

    @Override
    public boolean queryTableExist(@NotNull String table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return this.dbMeta.queryTableExist(table);
    }

    @Override
    @NotNull
    public String quote(@Nullable Object value) {
        return this.dbMeta.quote(value);
    }

    @Override
    @NotNull
    public String quoteColumn(@NotNull CharSequence column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        return this.dbMeta.quoteColumn(column);
    }

    @Override
    @NotNull
    public String quoteIdentifier(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.dbMeta.quoteIdentifier(id);
    }

    @Override
    @NotNull
    public String quoteSingleValue(@Nullable Object value) {
        return this.dbMeta.quoteSingleValue(value);
    }

    @Override
    @NotNull
    public String quoteTable(@NotNull CharSequence table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return this.dbMeta.quoteTable(table);
    }

    @Override
    @NotNull
    public String quoteTableAlias(@NotNull CharSequence table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return this.dbMeta.quoteTableAlias(table);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u0006R&\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lnet/jkcode/jkmvc/db/Db$Companion;", "", "()V", "dbs", "Lnet/jkcode/jkutil/ttl/AllRequestScopedTransferableThreadLocal;", "Ljava/util/HashMap;", "", "Lnet/jkcode/jkmvc/db/Db;", "getDbs", "()Lnet/jkcode/jkutil/ttl/AllRequestScopedTransferableThreadLocal;", "instance", "name", "jkmvc-orm"})
    public static final class Companion {
        @NotNull
        protected final AllRequestScopedTransferableThreadLocal<HashMap<CharSequence, Db>> getDbs() {
            return dbs;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Db instance(@NotNull CharSequence name) {
            Db db;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Map $receiver$iv = (Map)ScopedTransferableThreadLocal.get$default(this.getDbs(), (boolean)false, (int)1, null);
            Object value$iv = $receiver$iv.get(name);
            if (value$iv == null) {
                Db db2;
                boolean bl = false;
                if (DbConfig.INSTANCE.getCustomDbClass() != null) {
                    Class<?> clazz = DbConfig.INSTANCE.getCustomDbClass();
                    if (clazz == null) {
                        Intrinsics.throwNpe();
                    }
                    Object[] objectArray = clazz.getConstructors();
                    Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"DbConfig.customDbClass!!.constructors");
                    Object t = ((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(name);
                    if (t == null) {
                        throw new TypeCastException("null cannot be cast to non-null type net.jkcode.jkmvc.db.Db");
                    }
                    db2 = (Db)t;
                } else {
                    db2 = DbConfig.INSTANCE.isSharding(((Object)name).toString()) ? (Db)new ShardingDb(((Object)name).toString()) : (Db)new DruidSingleDb(((Object)name).toString());
                }
                Db answer$iv = db2;
                $receiver$iv.put(name, answer$iv);
                db = answer$iv;
            } else {
                void var3_3;
                db = var3_3;
            }
            return db;
        }

        @NotNull
        public static /* synthetic */ Db instance$default(Companion companion, CharSequence charSequence, int n, Object object) {
            if ((n & 1) != 0) {
                charSequence = "default";
            }
            return companion.instance(charSequence);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

