/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.db;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.jkcode.jkmvc.common._LoggerKt;
import net.jkcode.jkmvc.db.Cell;
import net.jkcode.jkmvc.db.Db;
import net.jkcode.jkmvc.db.DbConfig;
import net.jkcode.jkmvc.db.DbMeta;
import net.jkcode.jkmvc.db.DbType;
import net.jkcode.jkmvc.db.IDb;
import net.jkcode.jkmvc.db.IDbMeta;
import net.jkcode.jkmvc.db._ConnectionKt;
import net.jkcode.jkmvc.db.sharding.ShardingDb;
import net.jkcode.jkmvc.db.single.SingleDb;
import net.jkcode.jkmvc.ttl.AllRequestScopedTransferableThreadLocal;
import net.jkcode.jkmvc.ttl.ScopedTransferableThreadLocal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 o2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001oB\u0019\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u001c\u00108\u001a\u00020\u00012\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020302H\u0016J(\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00052\u000e\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0'2\u0006\u0010?\u001a\u00020+H\u0016J\b\u0010@\u001a\u000203H\u0016J\u0011\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005H\u0096\u0001J\b\u0010C\u001a\u00020\u0013H\u0016J*\u0010D\u001a\u00020E2\u0006\u0010<\u001a\u00020\u00052\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0'2\b\u0010G\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010H\u001a\u00020\u0013H\u0016J\b\u0010I\u001a\u000203H$J\b\u0010J\u001a\u000203H$J\b\u0010K\u001a\u000203H$J\b\u0010L\u001a\u00020\u0013H\u0016J\u0011\u0010M\u001a\u00020\u00132\u0006\u0010N\u001a\u00020\u0005H\u0096\u0001J\u0017\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00050'2\u0006\u0010P\u001a\u00020\u0005H\u0096\u0001J \u0010Q\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u00052\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0'H\u0016J\u0011\u0010R\u001a\u00020\u00052\u0006\u0010S\u001a\u00020\u0005H\u0096\u0001J@\u0010T\u001a\b\u0012\u0004\u0012\u0002HV0U\"\b\b\u0000\u0010V*\u00020>2\u0006\u0010<\u001a\u00020\u00052\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0'2\u000e\u0010W\u001a\n\u0012\u0004\u0012\u0002HV\u0018\u00010XH\u0016J@\u0010Y\u001a\b\u0012\u0004\u0012\u0002HV0'\"\b\b\u0000\u0010V*\u00020>2\u0006\u0010<\u001a\u00020\u00052\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0'2\u000e\u0010W\u001a\n\u0012\u0004\u0012\u0002HV\u0018\u00010XH\u0016J?\u0010Z\u001a\u0002HV\"\u0004\b\u0000\u0010V2\u0006\u0010<\u001a\u00020\u00052\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0'2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u0002HV02H\u0016\u00a2\u0006\u0002\u0010]JS\u0010^\u001a\u0004\u0018\u0001HV\"\u0004\b\u0000\u0010V2\u0006\u0010<\u001a\u00020\u00052\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0'2$\u0010_\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010>0&j\u0002``\u0012\u0004\u0012\u0002HV02H\u0016\u00a2\u0006\u0002\u0010]JR\u0010a\u001a\b\u0012\u0004\u0012\u0002HV0'\"\u0004\b\u0000\u0010V2\u0006\u0010<\u001a\u00020\u00052\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0'2$\u0010_\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010>0&j\u0002``\u0012\u0004\u0012\u0002HV02H\u0016J\u0013\u0010b\u001a\u00020\u00052\b\u0010c\u001a\u0004\u0018\u00010>H\u0096\u0001J\u0011\u0010d\u001a\u00020\u00052\u0006\u0010B\u001a\u00020eH\u0096\u0001J\u0011\u0010f\u001a\u00020\u00052\u0006\u0010g\u001a\u00020\u0005H\u0096\u0001J\u0013\u0010h\u001a\u00020\u00052\b\u0010c\u001a\u0004\u0018\u00010>H\u0096\u0001J\u0011\u0010i\u001a\u00020\u00052\u0006\u0010P\u001a\u00020eH\u0096\u0001J\b\u0010j\u001a\u00020\u0013H\u0016J!\u0010k\u001a\u0002HV\"\u0004\b\u0000\u0010V2\f\u0010l\u001a\b\u0012\u0004\u0012\u0002HV0mH\u0016\u00a2\u0006\u0002\u0010nR\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017R\u0014\u0010!\u001a\u0004\u0018\u00010\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001aR\u0012\u0010#\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000bR$\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050'0&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R-\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020302018DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b4\u00105\u00a8\u0006p"}, d2={"Lnet/jkcode/jkmvc/db/Db;", "Lnet/jkcode/jkmvc/db/IDb;", "Lnet/jkcode/jkmvc/db/IDbMeta;", "Ljava/io/Closeable;", "name", "", "dbMeta", "(Ljava/lang/String;Lnet/jkcode/jkmvc/db/IDbMeta;)V", "conn", "Ljava/sql/Connection;", "getConn", "()Ljava/sql/Connection;", "getDbMeta", "()Lnet/jkcode/jkmvc/db/IDbMeta;", "dbType", "Lnet/jkcode/jkmvc/db/DbType;", "getDbType", "()Lnet/jkcode/jkmvc/db/DbType;", "forceMaster", "", "getForceMaster", "()Z", "setForceMaster", "(Z)V", "identifierQuoteString", "getIdentifierQuoteString", "()Ljava/lang/String;", "masterConn", "getMasterConn", "getName", "rollbacked", "getRollbacked", "setRollbacked", "schema", "getSchema", "slaveConn", "getSlaveConn", "tableColumns", "", "", "getTableColumns", "()Ljava/util/Map;", "transDepth", "", "getTransDepth", "()I", "setTransDepth", "(I)V", "transactionCallbacks", "", "Lkotlin/Function1;", "", "getTransactionCallbacks", "()Ljava/util/List;", "transactionCallbacks$delegate", "Lkotlin/Lazy;", "addTransactionCallback", "callback", "batchExecute", "", "sql", "paramses", "", "paramSize", "begin", "column2Prop", "column", "commit", "execute", "", "params", "generatedColumn", "f", "handleBegin", "handleCommit", "handleRollback", "isInTransaction", "isKeyword", "col", "listColumns", "table", "previewSql", "prop2Column", "prop", "queryCell", "Lnet/jkcode/jkmvc/db/Cell;", "T", "clazz", "Lkotlin/reflect/KClass;", "queryColumn", "queryResult", "action", "Ljava/sql/ResultSet;", "(Ljava/lang/String;Ljava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "queryRow", "transform", "Lnet/jkcode/jkmvc/db/Row;", "queryRows", "quote", "value", "quoteColumn", "", "quoteIdentifier", "id", "quoteSingleValue", "quoteTable", "rollback", "transaction", "statement", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "jkmvc-orm"})
public abstract class Db
extends IDb
implements IDbMeta,
Closeable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private boolean forceMaster;
    private int transDepth;
    private boolean rollbacked;
    @NotNull
    private final Lazy transactionCallbacks$delegate;
    @NotNull
    private final String name;
    @NotNull
    private final IDbMeta dbMeta;
    @NotNull
    private static final AllRequestScopedTransferableThreadLocal<HashMap<String, Db>> dbs;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Db.class), "transactionCallbacks", "getTransactionCallbacks()Ljava/util/List;"))};
        Companion = new Companion(null);
        dbs = (AllRequestScopedTransferableThreadLocal)new AllRequestScopedTransferableThreadLocal<HashMap<String, Db>>((Function0)Companion.dbs.2.INSTANCE){

            public void doEndScope() {
                HashMap dbs2 = (HashMap)ScopedTransferableThreadLocal.get$default((ScopedTransferableThreadLocal)this, (boolean)false, (int)1, null);
                Map map = dbs2;
                Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> entry;
                    Map.Entry<K, V> entry2 = entry = iterator.next();
                    String name = (String)entry2.getKey();
                    entry2 = entry;
                    Db db = (Db)entry2.getValue();
                    db.close();
                }
                dbs2.clear();
                super.doEndScope();
            }
        };
    }

    @NotNull
    protected abstract Connection getMasterConn();

    @NotNull
    protected abstract Connection getSlaveConn();

    public final boolean getForceMaster() {
        return this.forceMaster;
    }

    public final void setForceMaster(boolean bl) {
        this.forceMaster = bl;
    }

    @NotNull
    public final Connection getConn() {
        if (this.isInTransaction() || this.forceMaster) {
            return this.getMasterConn();
        }
        return this.getSlaveConn();
    }

    protected final int getTransDepth() {
        return this.transDepth;
    }

    protected final void setTransDepth(int n) {
        this.transDepth = n;
    }

    protected final boolean getRollbacked() {
        return this.rollbacked;
    }

    protected final void setRollbacked(boolean bl) {
        this.rollbacked = bl;
    }

    @NotNull
    protected final List<Function1<Boolean, Unit>> getTransactionCallbacks() {
        Lazy lazy = this.transactionCallbacks$delegate;
        Db db = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public IDb forceMaster(boolean f) {
        this.forceMaster = f;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <T> T transaction(@NotNull Function0<? extends T> statement) {
        CompletableFuture completableFuture;
        Throwable rh$iv;
        CompletableFuture result$iv;
        block9: {
            Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
            this.begin();
            boolean $i$f$trySupplierFinally = false;
            result$iv = null;
            rh$iv = null;
            try {
                result$iv = statement.invoke();
                if (!(result$iv instanceof CompletableFuture)) break block9;
                CompletableFuture result2$iv = new CompletableFuture();
                ((CompletableFuture)result$iv).whenComplete(new BiConsumer<Object, Throwable>(result2$iv, this){
                    final /* synthetic */ CompletableFuture $result2;
                    final /* synthetic */ Db this$0;
                    {
                        this.$result2 = completableFuture;
                        this.this$0 = db;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void accept(Object r, Throwable ex) {
                        try {
                            void ex2;
                            Throwable throwable = ex;
                            Object r2 = r;
                            boolean bl = false;
                            if (ex2 != null) {
                                this.this$0.rollback();
                                throw ex2;
                            }
                            this.this$0.commit();
                            Object r22 = r2;
                            this.$result2.complete(r22);
                        }
                        catch (Throwable ex3) {
                            this.$result2.completeExceptionally(ex3);
                        }
                    }
                });
                result$iv = result2$iv;
            }
            catch (Throwable r$iv) {
                try {
                    rh$iv = r$iv;
                    r$iv.printStackTrace();
                }
                catch (Throwable throwable) {
                    void var3_3;
                    if (!(result$iv instanceof CompletableFuture)) {
                        Throwable ex = rh$iv;
                        CompletableFuture r = result$iv;
                        boolean bl = false;
                        if (ex != null) {
                            this.rollback();
                            throw ex;
                        }
                        this.commit();
                        result$iv = r;
                    }
                    completableFuture = var3_3;
                }
                if (!(result$iv instanceof CompletableFuture)) {
                    Throwable ex = rh$iv;
                    CompletableFuture r = result$iv;
                    boolean bl = false;
                    if (ex != null) {
                        this.rollback();
                        throw ex;
                    }
                    this.commit();
                    result$iv = r;
                }
                completableFuture = result$iv;
            }
        }
        if (!(result$iv instanceof CompletableFuture)) {
            Throwable throwable = rh$iv;
            CompletableFuture r = result$iv;
            boolean bl = false;
            this.commit();
            result$iv = r;
        }
        completableFuture = result$iv;
        return (T)completableFuture;
    }

    @Override
    @NotNull
    public IDb addTransactionCallback(@NotNull Function1<? super Boolean, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.getTransactionCallbacks().add(callback);
        return this;
    }

    protected abstract void handleBegin();

    protected abstract void handleCommit();

    protected abstract void handleRollback();

    @Override
    public void begin() {
        int n = this.transDepth;
        this.transDepth = n + 1;
        if (n == 0) {
            this.handleBegin();
        }
    }

    @Override
    public boolean commit() {
        if (this.transDepth <= 0) {
            return false;
        }
        Db db = this;
        db.transDepth += -1;
        if (db.transDepth == 0) {
            if (this.rollbacked) {
                this.handleRollback();
            } else {
                this.handleCommit();
            }
            boolean result = !this.rollbacked;
            Iterable $receiver$iv = this.getTransactionCallbacks();
            for (Object element$iv : $receiver$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)result);
            }
            this.rollbacked = false;
            return result;
        }
        return true;
    }

    @Override
    public boolean rollback() {
        if (this.transDepth <= 0) {
            return false;
        }
        Db db = this;
        db.transDepth += -1;
        if (db.transDepth == 0) {
            this.rollbacked = false;
            this.handleRollback();
            Iterable $receiver$iv = this.getTransactionCallbacks();
            for (Object element$iv : $receiver$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)false);
            }
        }
        this.rollbacked = true;
        return true;
    }

    @Override
    public boolean isInTransaction() {
        return this.transDepth > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String previewSql(@NotNull String sql, @NotNull List<? extends Object> params) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        if (params.isEmpty()) {
            return sql;
        }
        Collection $receiver$iv = params;
        boolean $i$f$mapToArray = false;
        String[] arr$iv = new String[$receiver$iv.size()];
        int i$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void it;
            String string;
            int n = i$iv++;
            Object e = item$iv;
            int n2 = n;
            String[] stringArray = arr$iv;
            boolean bl = false;
            stringArray[n2] = string = this.quote(it);
        }
        String[] ps = arr$iv;
        String string = StringsKt.replace$default((String)sql, (String)"?", (String)"%s", (boolean)false, (int)4, null);
        String[] stringArray = Arrays.copyOf(ps, ps.length);
        String string2 = String.format(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    @Override
    public long execute(@NotNull String sql, @NotNull List<? extends Object> params, @Nullable String generatedColumn) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        try {
            return _ConnectionKt.execute(this.getMasterConn(), sql, params, generatedColumn);
        }
        catch (Exception e) {
            _LoggerKt.getDbLogger().error("\u51fa\u9519[{}] sql: {}", (Object)e.getMessage(), (Object)this.previewSql(sql, params));
            throw (Throwable)e;
        }
    }

    @Override
    @NotNull
    public int[] batchExecute(@NotNull String sql, @NotNull List<? extends Object> paramses, int paramSize) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(paramses, (String)"paramses");
        try {
            return _ConnectionKt.batchExecute(this.getMasterConn(), sql, paramses, paramSize);
        }
        catch (Exception e) {
            _LoggerKt.getDbLogger().error("\u51fa\u9519[{}], sql={}, params={}", new Object[]{e.getMessage(), sql, paramses});
            throw (Throwable)e;
        }
    }

    @Override
    public <T> T queryResult(@NotNull String sql, @NotNull List<? extends Object> params, @NotNull Function1<? super ResultSet, ? extends T> action) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        try {
            return _ConnectionKt.queryResult(this.getConn(), sql, params, action);
        }
        catch (Exception e) {
            _LoggerKt.getDbLogger().error("\u51fa\u9519[{}] sql: {}", (Object)e.getMessage(), (Object)this.previewSql(sql, params));
            throw (Throwable)e;
        }
    }

    @Override
    @Nullable
    public <T> T queryRow(@NotNull String sql, @NotNull List<? extends Object> params, @NotNull Function1<? super Map<String, ? extends Object>, ? extends T> transform) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intrinsics.checkParameterIsNotNull(transform, (String)"transform");
        try {
            return _ConnectionKt.queryRow(this.getConn(), sql, params, transform);
        }
        catch (Exception e) {
            _LoggerKt.getDbLogger().error("\u51fa\u9519[{}] sql: {}", (Object)e.getMessage(), (Object)this.previewSql(sql, params));
            throw (Throwable)e;
        }
    }

    @Override
    @NotNull
    public <T> List<T> queryRows(@NotNull String sql, @NotNull List<? extends Object> params, @NotNull Function1<? super Map<String, ? extends Object>, ? extends T> transform) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intrinsics.checkParameterIsNotNull(transform, (String)"transform");
        try {
            return _ConnectionKt.queryRows(this.getConn(), sql, params, transform);
        }
        catch (Exception e) {
            _LoggerKt.getDbLogger().error("\u51fa\u9519[{}] sql: {}", (Object)e.getMessage(), (Object)this.previewSql(sql, params));
            throw (Throwable)e;
        }
    }

    @Override
    @NotNull
    public <T> List<T> queryColumn(@NotNull String sql, @NotNull List<? extends Object> params, @Nullable KClass<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        try {
            return _ConnectionKt.queryColumn$default(this.getConn(), sql, params, null, 4, null);
        }
        catch (Exception e) {
            _LoggerKt.getDbLogger().error("\u51fa\u9519[{}] sql: {}", (Object)e.getMessage(), (Object)this.previewSql(sql, params));
            throw (Throwable)e;
        }
    }

    @Override
    @NotNull
    public <T> Cell<T> queryCell(@NotNull String sql, @NotNull List<? extends Object> params, @Nullable KClass<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        try {
            return _ConnectionKt.queryCell(this.getConn(), sql, params, clazz);
        }
        catch (Exception e) {
            _LoggerKt.getDbLogger().error("\u51fa\u9519[{}] sql: {}", (Object)e.getMessage(), (Object)this.previewSql(sql, params));
            throw (Throwable)e;
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public IDbMeta getDbMeta() {
        return this.dbMeta;
    }

    protected Db(@NotNull String name, @NotNull IDbMeta dbMeta) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)dbMeta, (String)"dbMeta");
        this.name = name;
        this.dbMeta = dbMeta;
        this.transactionCallbacks$delegate = LazyKt.lazy((Function0)transactionCallbacks.2.INSTANCE);
    }

    public /* synthetic */ Db(String string, IDbMeta iDbMeta, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iDbMeta = DbMeta.Companion.get(string);
        }
        this(string, iDbMeta);
    }

    @Override
    @NotNull
    public DbType getDbType() {
        return this.dbMeta.getDbType();
    }

    @Override
    @NotNull
    public String getIdentifierQuoteString() {
        return this.dbMeta.getIdentifierQuoteString();
    }

    @Override
    @Nullable
    public String getSchema() {
        return this.dbMeta.getSchema();
    }

    @Override
    @NotNull
    public Map<String, List<String>> getTableColumns() {
        return this.dbMeta.getTableColumns();
    }

    @Override
    @NotNull
    public String column2Prop(@NotNull String column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        return this.dbMeta.column2Prop(column);
    }

    @Override
    public boolean isKeyword(@NotNull String col) {
        Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
        return this.dbMeta.isKeyword(col);
    }

    @Override
    @NotNull
    public List<String> listColumns(@NotNull String table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return this.dbMeta.listColumns(table);
    }

    @Override
    @NotNull
    public String prop2Column(@NotNull String prop) {
        Intrinsics.checkParameterIsNotNull((Object)prop, (String)"prop");
        return this.dbMeta.prop2Column(prop);
    }

    @Override
    @NotNull
    public String quote(@Nullable Object value) {
        return this.dbMeta.quote(value);
    }

    @Override
    @NotNull
    public String quoteColumn(@NotNull CharSequence column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        return this.dbMeta.quoteColumn(column);
    }

    @Override
    @NotNull
    public String quoteIdentifier(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.dbMeta.quoteIdentifier(id);
    }

    @Override
    @NotNull
    public String quoteSingleValue(@Nullable Object value) {
        return this.dbMeta.quoteSingleValue(value);
    }

    @Override
    @NotNull
    public String quoteTable(@NotNull CharSequence table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return this.dbMeta.quoteTable(table);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u0006R&\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lnet/jkcode/jkmvc/db/Db$Companion;", "", "()V", "dbs", "Lnet/jkcode/jkmvc/ttl/AllRequestScopedTransferableThreadLocal;", "Ljava/util/HashMap;", "", "Lnet/jkcode/jkmvc/db/Db;", "getDbs", "()Lnet/jkcode/jkmvc/ttl/AllRequestScopedTransferableThreadLocal;", "instance", "name", "jkmvc-orm"})
    public static final class Companion {
        @NotNull
        protected final AllRequestScopedTransferableThreadLocal<HashMap<String, Db>> getDbs() {
            return dbs;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Db instance(@NotNull String name) {
            Db db;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Map $receiver$iv = (Map)ScopedTransferableThreadLocal.get$default(this.getDbs(), (boolean)false, (int)1, null);
            Object value$iv = $receiver$iv.get(name);
            if (value$iv == null) {
                boolean bl = false;
                Db answer$iv = DbConfig.INSTANCE.isSharding(name) ? (Db)new ShardingDb(name) : (Db)new SingleDb(name);
                $receiver$iv.put(name, answer$iv);
                db = answer$iv;
            } else {
                void var3_3;
                db = var3_3;
            }
            return db;
        }

        @NotNull
        public static /* synthetic */ Db instance$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "default";
            }
            return companion.instance(string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

