/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.validator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nJ \u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u0004J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nJ&\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u0004J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u0004J\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\nJ\u001e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n\u00a8\u0006 "}, d2={"Lnet/jkcode/jkmvc/validator/ValidateFuncDefinition;", "", "()V", "between", "", "value", "", "min", "max", "digit", "", "email", "endsWith", "suffix", "ignoreCase", "length", "notEmpty", "numeric", "range", "step", "startsWith", "prefix", "strEquals", "other", "substring", "startIndex", "endIndex", "toLowerCase", "toUpperCase", "trim", "wrap", "postfix", "jkmvc-common"})
public final class ValidateFuncDefinition {
    public static final ValidateFuncDefinition INSTANCE;

    public final boolean notEmpty(@Nullable Object value) {
        CharSequence charSequence;
        return value != null && (!(value instanceof String) || !((charSequence = (CharSequence)value).length() == 0));
    }

    public final boolean length(@NotNull String value, int min, int max) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        int len = value.length();
        return len >= min && (max > -1 || len <= max);
    }

    public final boolean min(int value, int min) {
        return value >= min;
    }

    public final boolean max(int value, int max) {
        return value <= max;
    }

    public final boolean between(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public final boolean range(int value, int min, int max, int step) {
        return value >= min && value <= max && (value - min) % step == 0;
    }

    public final boolean email(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = "^[\\w\\-\\.]+@[\\w\\-]+(\\.\\w+)+";
        return new Regex(string).matches((CharSequence)value);
    }

    public final boolean digit(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = "^\\d+$";
        return new Regex(string).matches((CharSequence)value);
    }

    public final boolean numeric(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = "^-?\\d+(\\.\\d+)?$";
        return new Regex(string).matches((CharSequence)value);
    }

    public final boolean strEquals(@NotNull String value, @NotNull String other, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return StringsKt.equals((String)value, (String)other, (boolean)ignoreCase);
    }

    public static /* synthetic */ boolean strEquals$default(ValidateFuncDefinition validateFuncDefinition, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return validateFuncDefinition.strEquals(string, string2, bl);
    }

    public final boolean startsWith(@NotNull String value, @NotNull String prefix, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return StringsKt.startsWith((String)value, (String)prefix, (boolean)ignoreCase);
    }

    public static /* synthetic */ boolean startsWith$default(ValidateFuncDefinition validateFuncDefinition, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return validateFuncDefinition.startsWith(string, string2, bl);
    }

    public final boolean endsWith(@NotNull String value, @NotNull String suffix, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        return StringsKt.endsWith((String)value, (String)suffix, (boolean)ignoreCase);
    }

    public static /* synthetic */ boolean endsWith$default(ValidateFuncDefinition validateFuncDefinition, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return validateFuncDefinition.endsWith(string, string2, bl);
    }

    @NotNull
    public final String trim(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value;
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @NotNull
    public final String toUpperCase(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value;
        String string2 = string.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        return string2;
    }

    @NotNull
    public final String toLowerCase(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return string2;
    }

    @NotNull
    public final String substring(@NotNull String value, int startIndex, int endIndex) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value;
        int n = endIndex == -1 ? value.length() : endIndex;
        String string2 = string.substring(startIndex, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string2;
    }

    @NotNull
    public final String wrap(@NotNull String value, @NotNull String prefix, @NotNull String postfix) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)postfix, (String)"postfix");
        return prefix + value + postfix;
    }

    private ValidateFuncDefinition() {
    }

    static {
        ValidateFuncDefinition validateFuncDefinition;
        INSTANCE = validateFuncDefinition = new ValidateFuncDefinition();
    }
}

